/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.StompDecoder;
import org.springframework.messaging.simp.stomp.StompEncoder;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.io.Buffer;
import reactor.tcp.encoding.Codec;

public class StompCodec
implements Codec<Buffer, Message<byte[]>, Message<byte[]>> {
    private static final StompDecoder DECODER = new StompDecoder();
    private static final Function<Message<byte[]>, Buffer> ENCODER_FUNCTION = new Function<Message<byte[]>, Buffer>(){
        private final StompEncoder encoder = new StompEncoder();

        public Buffer apply(Message<byte[]> message) {
            return Buffer.wrap((byte[])this.encoder.encode(message));
        }
    };

    public Function<Buffer, Message<byte[]>> decoder(final Consumer<Message<byte[]>> next) {
        return new Function<Buffer, Message<byte[]>>(){

            public Message<byte[]> apply(Buffer buffer) {
                for (Message<byte[]> message : DECODER.decode(buffer.byteBuffer())) {
                    next.accept(message);
                }
                return null;
            }
        };
    }

    public Function<Message<byte[]>, Buffer> encoder() {
        return ENCODER_FUNCTION;
    }
}

