/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class MessageHeaderAccessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final MessageHeaders originalHeaders;
    private final Map<String, Object> headers = new HashMap<String, Object>(4);

    public MessageHeaderAccessor() {
        this.originalHeaders = null;
    }

    public MessageHeaderAccessor(Message<?> message) {
        this.originalHeaders = message != null ? message.getHeaders() : null;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.originalHeaders != null) {
            result.putAll(this.originalHeaders);
        }
        for (String key : this.headers.keySet()) {
            Object value = this.headers.get(key);
            if (value == null) {
                result.remove(key);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public boolean isModified() {
        return !this.headers.isEmpty();
    }

    public Object getHeader(String headerName) {
        if (this.headers.containsKey(headerName)) {
            return this.headers.get(headerName);
        }
        if (this.originalHeaders != null) {
            return this.originalHeaders.get(headerName);
        }
        return null;
    }

    public void setHeader(String name, Object value) {
        if (this.isReadOnly(name)) {
            throw new IllegalArgumentException("'" + name + "' header is read-only");
        }
        this.verifyType(name, value);
        if (!ObjectUtils.nullSafeEquals((Object)value, (Object)this.getHeader(name))) {
            this.headers.put(name, value);
        }
    }

    protected void verifyType(String headerName, Object headerValue) {
        if (headerName != null && headerValue != null && ("errorChannel".equals(headerName) || "replyChannel".endsWith(headerName)) && !(headerValue instanceof MessageChannel) && !(headerValue instanceof String)) {
            throw new IllegalArgumentException("'" + headerName + "' header value must be a MessageChannel or String");
        }
    }

    public void setHeaderIfAbsent(String name, Object value) {
        if (this.getHeader(name) == null) {
            this.setHeader(name, value);
        }
    }

    public void removeHeader(String headerName) {
        if (StringUtils.hasLength((String)headerName) && !this.isReadOnly(headerName)) {
            this.setHeader(headerName, null);
        }
    }

    public void removeHeaders(String ... headerPatterns) {
        ArrayList<String> headersToRemove = new ArrayList<String>();
        for (String pattern : headerPatterns) {
            if (!StringUtils.hasLength((String)pattern)) continue;
            if (pattern.contains("*")) {
                headersToRemove.addAll(this.getMatchingHeaderNames(pattern, this.headers));
                headersToRemove.addAll(this.getMatchingHeaderNames(pattern, this.originalHeaders));
                continue;
            }
            headersToRemove.add(pattern);
        }
        for (String headerToRemove : headersToRemove) {
            this.removeHeader(headerToRemove);
        }
    }

    private List<String> getMatchingHeaderNames(String pattern, Map<String, Object> headers) {
        ArrayList<String> matchingHeaderNames = new ArrayList<String>();
        if (headers != null) {
            for (Map.Entry<String, Object> header : headers.entrySet()) {
                if (!PatternMatchUtils.simpleMatch((String)pattern, (String)header.getKey())) continue;
                matchingHeaderNames.add(header.getKey());
            }
        }
        return matchingHeaderNames;
    }

    public void copyHeaders(Map<String, ?> headersToCopy) {
        if (headersToCopy != null) {
            Set<String> keys = headersToCopy.keySet();
            for (String key : keys) {
                if (this.isReadOnly(key)) continue;
                this.setHeader(key, headersToCopy.get(key));
            }
        }
    }

    public void copyHeadersIfAbsent(Map<String, ?> headersToCopy) {
        if (headersToCopy != null) {
            Set<String> keys = headersToCopy.keySet();
            for (String key : keys) {
                if (this.isReadOnly(key)) continue;
                this.setHeaderIfAbsent(key, headersToCopy.get(key));
            }
        }
    }

    protected boolean isReadOnly(String headerName) {
        return "id".equals(headerName) || "timestamp".equals(headerName);
    }

    public UUID getId() {
        return (UUID)this.getHeader("id");
    }

    public Long getTimestamp() {
        return (Long)this.getHeader("timestamp");
    }

    public void setReplyChannelName(String replyChannelName) {
        this.setHeader("replyChannel", replyChannelName);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setHeader("replyChannel", replyChannel);
    }

    public Object getReplyChannel() {
        return this.getHeader("replyChannel");
    }

    public void setErrorChannelName(String errorChannelName) {
        this.setHeader("errorChannel", errorChannelName);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.setHeader("errorChannel", errorChannel);
    }

    public Object getErrorChannel() {
        return this.getHeader("errorChannel");
    }

    public void setContentType(MimeType contentType) {
        this.setHeader("contentType", contentType);
    }

    public MimeType getContentType() {
        return (MimeType)this.getHeader("contentType");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [originalHeaders=" + this.originalHeaders + ", updated headers=" + this.headers + "]";
    }
}

