/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.core.MessageReceivingOperations;
import org.springframework.messaging.core.MessageRequestReplyOperations;

public abstract class AbstractMessagingTemplate<D>
extends AbstractMessageSendingTemplate<D>
implements MessageRequestReplyOperations<D>,
MessageReceivingOperations<D> {
    @Override
    public Message<?> receive() {
        return this.receive(this.getRequiredDefaultDestination());
    }

    @Override
    public Message<?> receive(D destination) {
        return this.doReceive(destination);
    }

    protected abstract Message<?> doReceive(D var1);

    @Override
    public <T> T receiveAndConvert(Class<T> targetClass) {
        return this.receiveAndConvert(this.getRequiredDefaultDestination(), targetClass);
    }

    @Override
    public <T> T receiveAndConvert(D destination, Class<T> targetClass) {
        Message<?> message = this.doReceive(destination);
        if (message != null) {
            return (T)this.getMessageConverter().fromMessage(message, targetClass);
        }
        return null;
    }

    @Override
    public Message<?> sendAndReceive(Message<?> requestMessage) {
        return this.sendAndReceive(this.getRequiredDefaultDestination(), requestMessage);
    }

    @Override
    public Message<?> sendAndReceive(D destination, Message<?> requestMessage) {
        return this.doSendAndReceive(destination, requestMessage);
    }

    protected abstract Message<?> doSendAndReceive(D var1, Message<?> var2);

    @Override
    public <T> T convertSendAndReceive(Object request, Class<T> targetClass) {
        return this.convertSendAndReceive(this.getRequiredDefaultDestination(), request, targetClass);
    }

    @Override
    public <T> T convertSendAndReceive(D destination, Object request, Class<T> targetClass) {
        return this.convertSendAndReceive(destination, request, null, targetClass);
    }

    @Override
    public <T> T convertSendAndReceive(D destination, Object request, Map<String, Object> headers, Class<T> targetClass) {
        return this.convertSendAndReceive(destination, request, headers, targetClass, null);
    }

    @Override
    public <T> T convertSendAndReceive(Object request, Class<T> targetClass, MessagePostProcessor postProcessor) {
        return this.convertSendAndReceive(this.getRequiredDefaultDestination(), request, targetClass, postProcessor);
    }

    @Override
    public <T> T convertSendAndReceive(D destination, Object request, Class<T> targetClass, MessagePostProcessor postProcessor) {
        return this.convertSendAndReceive(destination, request, null, targetClass, postProcessor);
    }

    @Override
    public <T> T convertSendAndReceive(D destination, Object request, Map<String, Object> headers, Class<T> targetClass, MessagePostProcessor postProcessor) {
        Message<?> replyMessage;
        MessageHeaders messageHeaders = headers != null ? new MessageHeaders(headers) : null;
        Message<?> requestMessage = this.getMessageConverter().toMessage(request, messageHeaders);
        if (requestMessage == null) {
            String payloadType = request != null ? request.getClass().getName() : null;
            Object contentType = messageHeaders != null ? messageHeaders.get("contentType") : null;
            throw new MessageConversionException("Unable to convert payload with type '" + payloadType + "', contentType='" + contentType + "', converter=[" + this.getMessageConverter() + "]");
        }
        if (postProcessor != null) {
            requestMessage = postProcessor.postProcessMessage(requestMessage);
        }
        return (T)((replyMessage = this.sendAndReceive(destination, requestMessage)) != null ? this.getMessageConverter().fromMessage(replyMessage, targetClass) : null);
    }
}

