/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.Assert;

public class SimpMessageHeaderAccessor
extends NativeMessageHeaderAccessor {
    public static final String CONNECT_MESSAGE_HEADER = "simpConnectMessage";
    public static final String DESTINATION_HEADER = "simpDestination";
    public static final String MESSAGE_TYPE_HEADER = "simpMessageType";
    public static final String SESSION_ID_HEADER = "simpSessionId";
    public static final String SESSION_ATTRIBUTES = "simpSessionAttributes";
    public static final String SUBSCRIPTION_ID_HEADER = "simpSubscriptionId";
    public static final String USER_HEADER = "simpUser";

    protected SimpMessageHeaderAccessor(SimpMessageType messageType, Map<String, List<String>> externalSourceHeaders) {
        super(externalSourceHeaders);
        Assert.notNull((Object)((Object)messageType), (String)"MessageType must not be null");
        this.setHeader(MESSAGE_TYPE_HEADER, (Object)messageType);
    }

    protected SimpMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    public static SimpMessageHeaderAccessor create() {
        return new SimpMessageHeaderAccessor(SimpMessageType.MESSAGE, null);
    }

    public static SimpMessageHeaderAccessor create(SimpMessageType messageType) {
        return new SimpMessageHeaderAccessor(messageType, null);
    }

    public static SimpMessageHeaderAccessor wrap(Message<?> message) {
        return new SimpMessageHeaderAccessor(message);
    }

    public void setMessageTypeIfNotSet(SimpMessageType messageType) {
        if (this.getMessageType() == null) {
            this.setHeader(MESSAGE_TYPE_HEADER, (Object)messageType);
        }
    }

    public SimpMessageType getMessageType() {
        return (SimpMessageType)((Object)this.getHeader(MESSAGE_TYPE_HEADER));
    }

    public void setDestination(String destination) {
        Assert.notNull((Object)destination, (String)"Destination must not be null");
        this.setHeader(DESTINATION_HEADER, destination);
    }

    public String getDestination() {
        return (String)this.getHeader(DESTINATION_HEADER);
    }

    public String getSubscriptionId() {
        return (String)this.getHeader(SUBSCRIPTION_ID_HEADER);
    }

    public void setSubscriptionId(String subscriptionId) {
        this.setHeader(SUBSCRIPTION_ID_HEADER, subscriptionId);
    }

    public String getSessionId() {
        return (String)this.getHeader(SESSION_ID_HEADER);
    }

    public void setSessionId(String sessionId) {
        this.setHeader(SESSION_ID_HEADER, sessionId);
    }

    public Map<String, Object> getSessionAttributes() {
        return (Map)this.getHeader(SESSION_ATTRIBUTES);
    }

    public void setSessionAttributes(Map<String, Object> attributes) {
        this.setHeader(SESSION_ATTRIBUTES, attributes);
    }

    public Principal getUser() {
        return (Principal)this.getHeader(USER_HEADER);
    }

    public void setUser(Principal principal) {
        this.setHeader(USER_HEADER, principal);
    }
}

