/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class StompDecoder {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final byte[] HEARTBEAT_PAYLOAD = new byte[]{10};
    private final Log logger = LogFactory.getLog(StompDecoder.class);

    public List<Message<byte[]>> decode(ByteBuffer buffer) {
        return this.decode(buffer, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public List<Message<byte[]>> decode(ByteBuffer buffer, MultiValueMap<String, String> headers) {
        Message<byte[]> message;
        Assert.notNull(headers, (String)"headers is required");
        ArrayList<Message<byte[]>> messages = new ArrayList<Message<byte[]>>();
        while (buffer.hasRemaining() && (message = this.decodeMessage(buffer, headers)) != null) {
            messages.add(message);
        }
        return messages;
    }

    private Message<byte[]> decodeMessage(ByteBuffer buffer, MultiValueMap<String, String> headers) {
        Message<byte[]> decodedMessage = null;
        this.skipLeadingEol(buffer);
        buffer.mark();
        String command = this.readCommand(buffer);
        if (command.length() > 0) {
            this.readHeaders(buffer, headers);
            byte[] payload = this.readPayload(buffer, headers);
            if (payload != null) {
                StompCommand stompCommand = StompCommand.valueOf(command);
                if (payload.length > 0 && !stompCommand.isBodyAllowed()) {
                    throw new StompConversionException((Object)((Object)stompCommand) + " shouldn't have but " + "has a payload with length=" + payload.length + ", headers=" + headers);
                }
                decodedMessage = MessageBuilder.withPayload(payload).setHeaders(StompHeaderAccessor.create(stompCommand, headers)).build();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Decoded " + decodedMessage));
                }
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Incomplete frame, resetting input buffer...");
                }
                buffer.reset();
            }
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Decoded heartbeat");
            }
            decodedMessage = MessageBuilder.withPayload(HEARTBEAT_PAYLOAD).setHeaders(StompHeaderAccessor.create(SimpMessageType.HEARTBEAT)).build();
        }
        return decodedMessage;
    }

    protected void skipLeadingEol(ByteBuffer buffer) {
        while (this.tryConsumeEndOfLine(buffer)) {
        }
    }

    private String readCommand(ByteBuffer buffer) {
        ByteArrayOutputStream command = new ByteArrayOutputStream(256);
        while (buffer.remaining() > 0 && !this.tryConsumeEndOfLine(buffer)) {
            command.write(buffer.get());
        }
        return new String(command.toByteArray(), UTF8_CHARSET);
    }

    private void readHeaders(ByteBuffer buffer, MultiValueMap<String, String> headers) {
        while (true) {
            ByteArrayOutputStream headerStream = new ByteArrayOutputStream(256);
            while (buffer.remaining() > 0 && !this.tryConsumeEndOfLine(buffer)) {
                headerStream.write(buffer.get());
            }
            if (headerStream.size() <= 0) break;
            String header = new String(headerStream.toByteArray(), UTF8_CHARSET);
            int colonIndex = header.indexOf(58);
            if (colonIndex <= 0 || colonIndex == header.length() - 1) {
                if (buffer.remaining() <= 0) continue;
                throw new StompConversionException("Illegal header: '" + header + "'. A header must be of the form <name>:<value>.");
            }
            String headerName = this.unescape(header.substring(0, colonIndex));
            String headerValue = this.unescape(header.substring(colonIndex + 1));
            headers.add((Object)headerName, (Object)headerValue);
        }
    }

    private String unescape(String inString) {
        StringBuilder sb = new StringBuilder(inString.length());
        int pos = 0;
        int index = inString.indexOf("\\");
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            if (index + 1 >= inString.length()) {
                throw new StompConversionException("Illegal escape sequence at index " + index + ": " + inString);
            }
            Character c = Character.valueOf(inString.charAt(index + 1));
            if (c.charValue() == 'r') {
                sb.append('\r');
            } else if (c.charValue() == 'n') {
                sb.append('\n');
            } else if (c.charValue() == 'c') {
                sb.append(':');
            } else if (c.charValue() == '\\') {
                sb.append('\\');
            } else {
                throw new StompConversionException("Illegal escape sequence at index " + index + ": " + inString);
            }
            pos = index + 2;
            index = inString.indexOf("\\", pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    private byte[] readPayload(ByteBuffer buffer, MultiValueMap<String, String> headers) {
        Integer contentLength = this.getContentLength(headers);
        if (contentLength != null && contentLength >= 0) {
            if (buffer.remaining() > contentLength) {
                byte[] payload = new byte[contentLength.intValue()];
                buffer.get(payload);
                if (buffer.get() != 0) {
                    throw new StompConversionException("Frame must be terminated with a null octet");
                }
                return payload;
            }
            return null;
        }
        ByteArrayOutputStream payload = new ByteArrayOutputStream(256);
        while (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (b == 0) {
                return payload.toByteArray();
            }
            payload.write(b);
        }
        return null;
    }

    protected Integer getContentLength(MultiValueMap<String, String> headers) {
        if (headers.containsKey((Object)"content-length")) {
            String rawContentLength = (String)headers.getFirst((Object)"content-length");
            try {
                return Integer.valueOf(rawContentLength);
            }
            catch (NumberFormatException ex) {
                this.logger.warn((Object)("Ignoring invalid content-length header value: '" + rawContentLength + "'"));
            }
        }
        return null;
    }

    private boolean tryConsumeEndOfLine(ByteBuffer buffer) {
        if (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (b == 10) {
                return true;
            }
            if (b == 13) {
                if (buffer.remaining() > 0 && buffer.get() == 10) {
                    return true;
                }
                throw new StompConversionException("'\\r' must be followed by '\\n'");
            }
            buffer.position(buffer.position() - 1);
        }
        return false;
    }
}

