/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;

public final class StompEncoder {
    private static final byte LF = 10;
    private static final byte COLON = 58;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final Log logger = LogFactory.getLog(StompEncoder.class);

    public byte[] encode(Message<byte[]> message) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128 + message.getPayload().length);
            DataOutputStream output = new DataOutputStream(baos);
            StompHeaderAccessor headers = StompHeaderAccessor.wrap(message);
            if (SimpMessageType.HEARTBEAT == headers.getMessageType()) {
                this.logger.trace((Object)"Encoded heartbeat");
                output.write(message.getPayload());
            } else {
                output.write(headers.getCommand().toString().getBytes(UTF8_CHARSET));
                output.write(10);
                this.writeHeaders(headers, message, output);
                output.write(10);
                this.writeBody(message, output);
                output.write(0);
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new StompConversionException("Failed to encode STOMP frame", ex);
        }
    }

    private void writeHeaders(StompHeaderAccessor headers, Message<byte[]> message, DataOutputStream output) throws IOException {
        boolean shouldEscape;
        StompCommand command = headers.getCommand();
        Map<String, List<String>> stompHeaders = headers.toStompHeaderMap();
        boolean bl = shouldEscape = command != StompCommand.CONNECT && command != StompCommand.CONNECTED;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Encoded STOMP " + (Object)((Object)command) + ", headers=" + stompHeaders));
        }
        for (Map.Entry<String, List<String>> entry : stompHeaders.entrySet()) {
            byte[] key = this.encodeHeaderString(entry.getKey(), shouldEscape);
            for (String value : entry.getValue()) {
                output.write(key);
                output.write(58);
                output.write(this.encodeHeaderString(value, shouldEscape));
                output.write(10);
            }
        }
        if (command.requiresContentLength()) {
            int contentLength = message.getPayload().length;
            output.write("content-length:".getBytes(UTF8_CHARSET));
            output.write(Integer.toString(contentLength).getBytes(UTF8_CHARSET));
            output.write(10);
        }
    }

    private byte[] encodeHeaderString(String input, boolean escape) {
        String inputToUse = escape ? this.escape(input) : input;
        return inputToUse.getBytes(UTF8_CHARSET);
    }

    private String escape(String inString) {
        StringBuilder sb = new StringBuilder(inString.length());
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == ':') {
                sb.append("\\c");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void writeBody(Message<byte[]> message, DataOutputStream output) throws IOException {
        output.write(message.getPayload());
    }
}

