/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;

public class ExecutorSubscribableChannel
extends AbstractSubscribableChannel {
    private final Executor executor;
    private final List<ExecutorChannelInterceptor> executorInterceptors = new ArrayList<ExecutorChannelInterceptor>(4);

    public ExecutorSubscribableChannel() {
        this(null);
    }

    public ExecutorSubscribableChannel(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        super.setInterceptors(interceptors);
        this.executorInterceptors.clear();
        for (ChannelInterceptor interceptor : interceptors) {
            if (!(interceptor instanceof ExecutorChannelInterceptor)) continue;
            this.executorInterceptors.add((ExecutorChannelInterceptor)interceptor);
        }
    }

    @Override
    public void addInterceptor(ChannelInterceptor interceptor) {
        super.addInterceptor(interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            this.executorInterceptors.add((ExecutorChannelInterceptor)interceptor);
        }
    }

    @Override
    public boolean sendInternal(Message<?> message, long timeout) {
        for (MessageHandler subscriber : this.getSubscribers()) {
            ExecutorChannelInterceptorChain chain = new ExecutorChannelInterceptorChain();
            SendTask sendTask = new SendTask(message, this, subscriber, chain);
            if (this.executor == null) {
                sendTask.run();
                continue;
            }
            this.executor.execute(sendTask);
        }
        return true;
    }

    private static class SendTask
    implements Runnable {
        private final Message<?> inputMessage;
        private final MessageChannel channel;
        private final MessageHandler handler;
        private final ExecutorChannelInterceptorChain chain;

        public SendTask(Message<?> message, MessageChannel channel, MessageHandler handler, ExecutorChannelInterceptorChain chain) {
            this.inputMessage = message;
            this.channel = channel;
            this.handler = handler;
            this.chain = chain;
        }

        @Override
        public void run() {
            Message<?> message = this.inputMessage;
            try {
                message = this.chain.applyBeforeHandle(message, this.channel, this.handler);
                if (message == null) {
                    return;
                }
                this.handler.handleMessage(message);
                this.chain.triggerAfterMessageHandled(message, this.channel, this.handler, null);
            }
            catch (Exception ex) {
                this.chain.triggerAfterMessageHandled(message, this.channel, this.handler, ex);
                if (ex instanceof MessagingException) {
                    throw (MessagingException)((Object)ex);
                }
                throw new MessageDeliveryException(message, "Failed to handle message to " + this.channel + " in " + this.handler, ex);
            }
            catch (Error ex) {
                this.chain.triggerAfterMessageHandled(message, this.channel, this.handler, (Exception)((Object)new MessageDeliveryException(message, "Failed to handle message to " + this.channel + " in " + this.handler, ex)));
                throw ex;
            }
        }
    }

    private class ExecutorChannelInterceptorChain {
        private int interceptorIndex = -1;

        private ExecutorChannelInterceptorChain() {
        }

        public Message<?> applyBeforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
            for (ExecutorChannelInterceptor interceptor : ExecutorSubscribableChannel.this.executorInterceptors) {
                message = interceptor.beforeHandle(message, channel, handler);
                if (message == null) {
                    String name = interceptor.getClass().getSimpleName();
                    if (ExecutorSubscribableChannel.this.logger.isDebugEnabled()) {
                        ExecutorSubscribableChannel.this.logger.debug((Object)(name + " returned null from beforeHandle, i.e. precluding the send."));
                    }
                    this.triggerAfterMessageHandled(message, channel, handler, null);
                    return null;
                }
                ++this.interceptorIndex;
            }
            return message;
        }

        public void triggerAfterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
            for (int i = this.interceptorIndex; i >= 0; --i) {
                ExecutorChannelInterceptor interceptor = (ExecutorChannelInterceptor)ExecutorSubscribableChannel.this.executorInterceptors.get(i);
                try {
                    interceptor.afterMessageHandled(message, channel, handler, ex);
                    continue;
                }
                catch (Throwable ex2) {
                    ExecutorSubscribableChannel.this.logger.error((Object)("Exception from afterMessageHandled in " + interceptor), ex2);
                }
            }
        }
    }
}

