/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.simp.config.TaskExecutorRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ChannelRegistration {
    private @Nullable TaskExecutorRegistration registration;
    private @Nullable Executor executor;
    private final List<ChannelInterceptor> interceptors = new ArrayList<ChannelInterceptor>();

    public TaskExecutorRegistration taskExecutor() {
        return this.taskExecutor(null);
    }

    public TaskExecutorRegistration taskExecutor(@Nullable ThreadPoolTaskExecutor taskExecutor) {
        if (this.registration == null) {
            this.registration = taskExecutor != null ? new TaskExecutorRegistration(taskExecutor) : new TaskExecutorRegistration();
        }
        return this.registration;
    }

    public ChannelRegistration executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public ChannelRegistration interceptors(ChannelInterceptor ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    protected boolean hasExecutor() {
        return this.registration != null || this.executor != null;
    }

    protected boolean hasInterceptors() {
        return !this.interceptors.isEmpty();
    }

    protected Executor getExecutor(Supplier<Executor> fallback, Consumer<Executor> customizer) {
        if (this.executor != null) {
            return this.executor;
        }
        if (this.registration != null) {
            ThreadPoolTaskExecutor registeredTaskExecutor = this.registration.getTaskExecutor();
            if (!this.registration.isExternallyDefined()) {
                customizer.accept((Executor)registeredTaskExecutor);
            }
            return registeredTaskExecutor;
        }
        Executor fallbackExecutor = fallback.get();
        customizer.accept(fallbackExecutor);
        return fallbackExecutor;
    }

    protected List<ChannelInterceptor> getInterceptors() {
        return this.interceptors;
    }
}

