/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mock.web.DelegatingServletOutputStream;
import org.springframework.util.Assert;

public class MockHttpServletResponse
implements HttpServletResponse {
    public static final int DEFAULT_SERVER_PORT = 80;
    private static final String CHARSET_PREFIX = "charset=";
    private String characterEncoding = "ISO-8859-1";
    private final ByteArrayOutputStream content = new ByteArrayOutputStream();
    private final DelegatingServletOutputStream outputStream = new DelegatingServletOutputStream(this.content);
    private PrintWriter writer;
    private int contentLength = 0;
    private String contentType;
    private int bufferSize = 4096;
    private boolean committed;
    private Locale locale = Locale.getDefault();
    private final List cookies = new ArrayList();
    private final Map headers = new HashMap();
    private int status = 200;
    private String errorMessage;
    private String redirectedUrl;
    private String forwardedUrl;
    private String includedUrl;

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.content, this.characterEncoding) : new OutputStreamWriter(this.content);
            this.writer = new PrintWriter(targetWriter);
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        this.flushBuffer();
        return this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String contentType) {
        int charsetIndex;
        this.contentType = contentType;
        if (contentType != null && (charsetIndex = contentType.toLowerCase().indexOf(CHARSET_PREFIX)) != -1) {
            String encoding = contentType.substring(charsetIndex + CHARSET_PREFIX.length());
            this.setCharacterEncoding(encoding);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not flush OutputStream: " + ex.getMessage());
            }
        }
        this.committed = true;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.content.reset();
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0;
        this.contentType = null;
        this.locale = null;
        this.cookies.clear();
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
        Assert.notNull((Object)cookie, (String)"Cookie must not be null");
        this.cookies.add(cookie);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public Cookie getCookie(String name) {
        Assert.notNull((Object)name, (String)"Cookie name must not be null");
        Iterator it = this.cookies.iterator();
        while (it.hasNext()) {
            Cookie cookie = (Cookie)it.next();
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public boolean containsHeader(String name) {
        Assert.notNull((Object)name, (String)"Header name must not be null");
        return this.headers.containsKey(name);
    }

    public Set getHeaderNames() {
        return this.headers.keySet();
    }

    public Object getHeader(String name) {
        Assert.notNull((Object)name, (String)"Header name must not be null");
        return this.headers.get(name);
    }

    public List getHeaders(String name) {
        Assert.notNull((Object)name, (String)"Header name must not be null");
        Object value = this.headers.get(name);
        if (value instanceof List) {
            return (List)value;
        }
        if (value != null) {
            return Collections.singletonList(value);
        }
        return Collections.EMPTY_LIST;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public void sendError(int status, String errorMessage) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.errorMessage = errorMessage;
        this.committed = true;
    }

    public void sendError(int status) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.committed = true;
    }

    public void sendRedirect(String url) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        Assert.notNull((Object)url, (String)"Redirect URL must not be null");
        this.redirectedUrl = url;
        this.committed = true;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public void setDateHeader(String name, long value) {
        Assert.notNull((Object)name, (String)"Header name must not be null");
        this.headers.put(name, new Long(value));
    }

    public void addDateHeader(String name, long value) {
        this.doAddHeader(name, new Long(value));
    }

    public void setHeader(String name, String value) {
        Assert.notNull((Object)name, (String)"Header name must not be null");
        this.headers.put(name, value);
    }

    public void addHeader(String name, String value) {
        this.doAddHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        Assert.notNull((Object)name, (String)"Header name must not be null");
        this.headers.put(name, new Integer(value));
    }

    public void addIntHeader(String name, int value) {
        this.doAddHeader(name, new Integer(value));
    }

    private void doAddHeader(String name, Object value) {
        Assert.notNull((Object)name, (String)"Header name must not be null");
        Assert.notNull((Object)value, (String)"Header value must not be null");
        Object oldValue = this.headers.get(name);
        if (oldValue instanceof List) {
            List list = (List)oldValue;
            list.add(value);
        } else if (oldValue != null) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(oldValue);
            list.add(value);
            this.headers.put(name, list);
        } else {
            this.headers.put(name, value);
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrl = includedUrl;
    }

    public String getIncludedUrl() {
        return this.includedUrl;
    }
}

