/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MockMultipartHttpServletRequest
extends MockHttpServletRequest
implements MultipartHttpServletRequest {
    private final Map multipartFiles = CollectionFactory.createLinkedMapIfPossible((int)4);

    public void addFile(MultipartFile file) {
        Assert.notNull((Object)file, (String)"MultipartFile must not be null");
        this.multipartFiles.put(file.getName(), file);
    }

    public Iterator getFileNames() {
        return this.getFileMap().keySet().iterator();
    }

    public MultipartFile getFile(String name) {
        return (MultipartFile)this.multipartFiles.get(name);
    }

    public Map getFileMap() {
        return Collections.unmodifiableMap(this.multipartFiles);
    }
}

