/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.util.Assert;

public class MockServletConfig
implements ServletConfig {
    private final ServletContext servletContext;
    private final String servletName;
    private final Properties initParameters = new Properties();

    public MockServletConfig(ServletContext servletContext) {
        this(servletContext, "");
    }

    public MockServletConfig(ServletContext servletContext, String servletName) {
        this.servletContext = servletContext;
        this.servletName = servletName;
    }

    public String getServletName() {
        return this.servletName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.initParameters.setProperty(name, value);
    }

    public String getInitParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        return this.initParameters.getProperty(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }
}

