/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PessimisticLockException;
import org.hibernate.PropertyValueException;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.lang.Nullable;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class HibernateJpaDialect
extends DefaultJpaDialect {
    private static Method getFlushMode;
    boolean prepareConnection = true;

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    @Override
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        Session session = this.getSession(entityManager);
        if (definition.getTimeout() != -1) {
            session.getTransaction().setTimeout(definition.getTimeout());
        }
        boolean isolationLevelNeeded = definition.getIsolationLevel() != -1;
        Integer previousIsolationLevel = null;
        Connection preparedCon = null;
        if (isolationLevelNeeded || definition.isReadOnly()) {
            if (this.prepareConnection) {
                preparedCon = HibernateConnectionHandle.doGetConnection(session);
                previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)preparedCon, (TransactionDefinition)definition);
            } else if (isolationLevelNeeded) {
                throw new InvalidIsolationLevelException(this.getClass().getSimpleName() + " does not support custom isolation levels since the 'prepareConnection' flag is off.");
            }
        }
        entityManager.getTransaction().begin();
        FlushMode previousFlushMode = this.prepareFlushMode(session, definition.isReadOnly());
        return new SessionTransactionData(session, previousFlushMode, preparedCon, previousIsolationLevel);
    }

    @Override
    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, @Nullable String name) throws PersistenceException {
        Session session = this.getSession(entityManager);
        FlushMode previousFlushMode = this.prepareFlushMode(session, readOnly);
        return new SessionTransactionData(session, previousFlushMode, null, null);
    }

    @Nullable
    protected FlushMode prepareFlushMode(Session session, boolean readOnly) throws PersistenceException {
        FlushMode flushMode = (FlushMode)ReflectionUtils.invokeMethod((Method)getFlushMode, (Object)session);
        Assert.state((flushMode != null ? 1 : 0) != 0, (String)"No FlushMode from Session");
        if (readOnly) {
            if (!flushMode.equals((Object)FlushMode.MANUAL)) {
                session.setFlushMode(FlushMode.MANUAL);
                return flushMode;
            }
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setFlushMode(FlushMode.AUTO);
            return flushMode;
        }
        return null;
    }

    @Override
    public void cleanupTransaction(@Nullable Object transactionData) {
        if (transactionData instanceof SessionTransactionData) {
            ((SessionTransactionData)transactionData).resetSessionState();
        }
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        Session session = this.getSession(entityManager);
        return new HibernateConnectionHandle(session);
    }

    @Override
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex);
        }
        if (ex instanceof PersistenceException && ex.getCause() instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex.getCause());
        }
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SQLGrammarException) {
            SQLGrammarException jdbcEx = (SQLGrammarException)ex;
            return new InvalidDataAccessResourceUsageException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof org.hibernate.QueryTimeoutException) {
            org.hibernate.QueryTimeoutException jdbcEx = (org.hibernate.QueryTimeoutException)ex;
            return new QueryTimeoutException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof LockAcquisitionException) {
            LockAcquisitionException jdbcEx = (LockAcquisitionException)ex;
            return new CannotAcquireLockException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof PessimisticLockException) {
            PessimisticLockException jdbcEx = (PessimisticLockException)ex;
            return new PessimisticLockingFailureException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException jdbcEx = (ConstraintViolationException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]; constraint [" + jdbcEx.getConstraintName() + "]", (Throwable)ex);
        }
        if (ex instanceof DataException) {
            DataException jdbcEx = (DataException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof QueryException) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof UnresolvableObjectException) {
            UnresolvableObjectException hibEx = (UnresolvableObjectException)ex;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof WrongClassException) {
            WrongClassException hibEx = (WrongClassException)ex;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            StaleObjectStateException hibEx = (StaleObjectStateException)ex;
            return new ObjectOptimisticLockingFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), (Throwable)ex);
        }
        if (ex instanceof StaleStateException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof OptimisticEntityLockException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PessimisticEntityLockException) {
            if (ex.getCause() instanceof LockAcquisitionException) {
                return new CannotAcquireLockException(ex.getMessage(), ex.getCause());
            }
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        return new JpaSystemException((RuntimeException)ex);
    }

    protected Session getSession(EntityManager entityManager) {
        return (Session)entityManager.unwrap(Session.class);
    }

    static {
        try {
            getFlushMode = Session.class.getMethod("getHibernateFlushMode", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                getFlushMode = Session.class.getMethod("getFlushMode", new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalStateException("No compatible Hibernate getFlushMode signature found", ex2);
            }
        }
        Assert.state((FlushMode.class == getFlushMode.getReturnType() ? 1 : 0) != 0, (String)"Could not find Hibernate getFlushMode method");
    }

    private static class HibernateConnectionHandle
    implements ConnectionHandle {
        @Nullable
        private static volatile Method connectionMethodToUse;
        private final Session session;

        public HibernateConnectionHandle(Session session) {
            this.session = session;
        }

        public Connection getConnection() {
            return HibernateConnectionHandle.doGetConnection(this.session);
        }

        public void releaseConnection(Connection con) {
        }

        public static Connection doGetConnection(Session session) {
            try {
                Connection con;
                Method methodToUse = connectionMethodToUse;
                if (methodToUse == null) {
                    connectionMethodToUse = methodToUse = session.getClass().getMethod("connection", new Class[0]);
                }
                Assert.state(((con = (Connection)ReflectionUtils.invokeMethod((Method)methodToUse, (Object)session)) != null ? 1 : 0) != 0, (String)"No Connection from Session");
                return con;
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Cannot find connection() method on Hibernate Session", ex);
            }
        }
    }

    private static class SessionTransactionData {
        private final Session session;
        @Nullable
        private final FlushMode previousFlushMode;
        @Nullable
        private final Connection preparedCon;
        @Nullable
        private final Integer previousIsolationLevel;

        public SessionTransactionData(Session session, @Nullable FlushMode previousFlushMode, @Nullable Connection preparedCon, @Nullable Integer previousIsolationLevel) {
            this.session = session;
            this.previousFlushMode = previousFlushMode;
            this.preparedCon = preparedCon;
            this.previousIsolationLevel = previousIsolationLevel;
        }

        public void resetSessionState() {
            if (this.previousFlushMode != null) {
                this.session.setFlushMode(this.previousFlushMode);
            }
            if (this.preparedCon != null && this.session.isConnected()) {
                Connection conToReset = HibernateConnectionHandle.doGetConnection(this.session);
                if (conToReset != this.preparedCon) {
                    LogFactory.getLog(HibernateJpaDialect.class).warn((Object)"JDBC Connection to reset not identical to originally prepared Connection - please make sure to use connection release mode ON_CLOSE (the default) and to run against Hibernate 4.2+ (or switch HibernateJpaDialect's prepareConnection flag to false");
                }
                DataSourceUtils.resetConnectionAfterTransaction((Connection)conToReset, (Integer)this.previousIsolationLevel);
            }
        }
    }
}

