/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HANADialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.jspecify.annotations.Nullable;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.orm.jpa.vendor.SpringHibernateJpaPersistenceProvider;

public class HibernateJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final HibernateJpaDialect jpaDialect = new HibernateJpaDialect();
    private final PersistenceProvider persistenceProvider = new SpringHibernateJpaPersistenceProvider();
    private final Class<? extends EntityManagerFactory> entityManagerFactoryInterface = SessionFactory.class;
    private final Class<? extends EntityManager> entityManagerInterface = Session.class;

    public void setPrepareConnection(boolean prepareConnection) {
        this.jpaDialect.setPrepareConnection(prepareConnection);
    }

    @Override
    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    @Override
    public String getPersistenceProviderRootPackage() {
        return "org.hibernate";
    }

    public Map<String, Object> getJpaPropertyMap(PersistenceUnitInfo pui) {
        SmartPersistenceUnitInfo spui;
        return this.buildJpaPropertyMap(this.jpaDialect.prepareConnection && pui instanceof SmartPersistenceUnitInfo && !(spui = (SmartPersistenceUnitInfo)pui).isConfiguredForJta());
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.buildJpaPropertyMap(this.jpaDialect.prepareConnection);
    }

    private Map<String, Object> buildJpaPropertyMap(boolean connectionReleaseOnClose) {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("hibernate.dialect", this.getDatabasePlatform());
        } else {
            Class<?> databaseDialectClass = this.determineDatabaseDialectClass(this.getDatabase());
            if (databaseDialectClass != null) {
                jpaProperties.put("hibernate.dialect", databaseDialectClass.getName());
            } else {
                String databaseDialectName = this.determineDatabaseDialectName(this.getDatabase());
                if (databaseDialectName != null) {
                    jpaProperties.put("hibernate.dialect", databaseDialectName);
                }
            }
        }
        if (this.isGenerateDdl()) {
            jpaProperties.put("hibernate.hbm2ddl.auto", "update");
        }
        if (this.isShowSql()) {
            jpaProperties.put("hibernate.show_sql", "true");
        }
        if (connectionReleaseOnClose) {
            jpaProperties.put("hibernate.connection.handling_mode", PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_HOLD);
        }
        jpaProperties.put("hibernate.cdi.extensions", "true");
        return jpaProperties;
    }

    protected @Nullable Class<?> determineDatabaseDialectClass(Database database) {
        return switch (database) {
            case Database.DB2 -> DB2Dialect.class;
            case Database.H2 -> H2Dialect.class;
            case Database.HANA -> HANADialect.class;
            case Database.HSQL -> HSQLDialect.class;
            case Database.MYSQL -> MySQLDialect.class;
            case Database.ORACLE -> OracleDialect.class;
            case Database.POSTGRESQL -> PostgreSQLDialect.class;
            case Database.SQL_SERVER -> SQLServerDialect.class;
            case Database.SYBASE -> SybaseDialect.class;
            default -> null;
        };
    }

    protected @Nullable String determineDatabaseDialectName(Database database) {
        return switch (database) {
            case Database.DERBY -> "org.hibernate.community.dialect.DerbyDialect";
            default -> null;
        };
    }

    @Override
    public HibernateJpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    @Override
    public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
        return this.entityManagerFactoryInterface;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return this.entityManagerInterface;
    }
}

