/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.web.portlet.HandlerExceptionResolver;
import org.springframework.web.portlet.ModelAndView;

public class SimpleMappingExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    public static final String DEFAULT_EXCEPTION_ATTRIBUTE = "exception";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Set mappedHandlers;
    private boolean renderWhenMinimized = false;
    private Log warnLogger;
    private Properties exceptionMappings;
    private String defaultErrorView;
    private String exceptionAttribute = "exception";
    static /* synthetic */ Class class$java$lang$Throwable;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setMappedHandlers(Set mappedHandlers) {
        this.mappedHandlers = mappedHandlers;
    }

    public void setRenderWhenMinimized(boolean renderWhenMinimized) {
        this.renderWhenMinimized = renderWhenMinimized;
    }

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = LogFactory.getLog((String)loggerName);
    }

    public void setExceptionMappings(Properties mappings) {
        this.exceptionMappings = mappings;
    }

    public void setDefaultErrorView(String defaultErrorView) {
        this.defaultErrorView = defaultErrorView;
    }

    public void setExceptionAttribute(String exceptionAttribute) {
        this.exceptionAttribute = exceptionAttribute;
    }

    public ModelAndView resolveException(RenderRequest request, RenderResponse response, Object handler, Exception ex) {
        if (this.mappedHandlers != null && !this.mappedHandlers.contains(handler)) {
            return null;
        }
        if (WindowState.MINIMIZED.equals((Object)request.getWindowState()) && !this.renderWhenMinimized) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving exception from handler [" + handler + "]: " + ex));
        }
        this.logException(ex, request);
        String viewName = this.determineViewName(ex, request);
        if (viewName != null) {
            return this.getModelAndView(viewName, ex, request);
        }
        return null;
    }

    protected void logException(Exception ex, RenderRequest request) {
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn((Object)this.buildLogMessage(ex, request), (Throwable)ex);
        }
    }

    protected String buildLogMessage(Exception ex, RenderRequest request) {
        return "Handler execution resulted in exception";
    }

    protected String determineViewName(Exception ex, RenderRequest request) {
        String viewName = null;
        if (this.exceptionMappings != null) {
            viewName = this.findMatchingViewName(this.exceptionMappings, ex);
        }
        if (viewName == null && this.defaultErrorView != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving to default view '" + this.defaultErrorView + "' for exception of type [" + ex.getClass().getName() + "]"));
            }
            viewName = this.defaultErrorView;
        }
        return viewName;
    }

    protected String findMatchingViewName(Properties exceptionMappings, Exception ex) {
        String viewName = null;
        String dominantMapping = null;
        int deepest = Integer.MAX_VALUE;
        Enumeration<?> names = exceptionMappings.propertyNames();
        while (names.hasMoreElements()) {
            String exceptionMapping = (String)names.nextElement();
            int depth = this.getDepth(exceptionMapping, ex);
            if (depth < 0 || depth >= deepest) continue;
            deepest = depth;
            dominantMapping = exceptionMapping;
            viewName = exceptionMappings.getProperty(exceptionMapping);
        }
        if (viewName != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving to view '" + viewName + "' for exception of type [" + ex.getClass().getName() + "], based on exception mapping [" + dominantMapping + "]"));
        }
        return viewName;
    }

    protected int getDepth(String exceptionMapping, Exception ex) {
        return this.getDepth(exceptionMapping, ex.getClass(), 0);
    }

    private int getDepth(String exceptionMapping, Class exceptionClass, int depth) {
        if (exceptionClass.getName().indexOf(exceptionMapping) != -1) {
            return depth;
        }
        if (exceptionClass.equals(class$java$lang$Throwable == null ? (class$java$lang$Throwable = SimpleMappingExceptionResolver.class$("java.lang.Throwable")) : class$java$lang$Throwable)) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex, RenderRequest request) {
        return this.getModelAndView(viewName, ex);
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex) {
        ModelAndView mv = new ModelAndView(viewName);
        if (this.exceptionAttribute != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Exposing Exception as model attribute '" + this.exceptionAttribute + "'"));
            }
            mv.addObject(this.exceptionAttribute, ex);
        }
        return mv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

