/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.portlet.context.ConfigurablePortletApplicationContext;
import org.springframework.web.portlet.context.PortletContextAwareProcessor;
import org.springframework.web.portlet.context.PortletContextResource;
import org.springframework.web.portlet.context.PortletContextResourcePatternResolver;

public class StaticPortletApplicationContext
extends StaticApplicationContext
implements ConfigurablePortletApplicationContext {
    private ServletContext servletContext;
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private String namespace;
    static /* synthetic */ Class class$org$springframework$web$portlet$context$PortletContextAware;
    static /* synthetic */ Class class$org$springframework$web$portlet$context$PortletConfigAware;

    public StaticPortletApplicationContext() {
        this.setDisplayName("Root Portlet ApplicationContext");
    }

    public void setParent(ApplicationContext parent) {
        super.setParent(parent);
        if (parent instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)parent).getServletContext();
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
        if (portletConfig != null && this.portletContext == null) {
            this.portletContext = portletConfig.getPortletContext();
        }
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("Portlet ApplicationContext for namespace '" + namespace + "'");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocations(String[] configLocations) {
        throw new UnsupportedOperationException("StaticPortletApplicationContext does not support config locations");
    }

    public String[] getConfigLocations() {
        return null;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope("request", (Scope)new RequestScope());
        beanFactory.registerScope("session", (Scope)new SessionScope(false));
        beanFactory.registerScope("globalSession", (Scope)new SessionScope(true));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new PortletContextAwareProcessor(this.portletContext, this.portletConfig));
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$portlet$context$PortletContextAware == null ? (class$org$springframework$web$portlet$context$PortletContextAware = StaticPortletApplicationContext.class$("org.springframework.web.portlet.context.PortletContextAware")) : class$org$springframework$web$portlet$context$PortletContextAware);
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$portlet$context$PortletConfigAware == null ? (class$org$springframework$web$portlet$context$PortletConfigAware = StaticPortletApplicationContext.class$("org.springframework.web.portlet.context.PortletConfigAware")) : class$org$springframework$web$portlet$context$PortletConfigAware);
    }

    protected Resource getResourceByPath(String path) {
        return new PortletContextResource(this.portletContext, path);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PortletContextResourcePatternResolver((ResourceLoader)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

