/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.multipart;

import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.fileupload.portlet.PortletRequestContext;
import org.springframework.util.ClassUtils;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.portlet.context.PortletContextAware;
import org.springframework.web.portlet.multipart.DefaultMultipartActionRequest;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;
import org.springframework.web.portlet.util.PortletUtils;

public class CommonsPortletMultipartResolver
extends CommonsFileUploadSupport
implements PortletMultipartResolver,
PortletContextAware {
    private final boolean commonsFileUpload12Present = ClassUtils.hasMethod((Class)(class$org$apache$commons$fileupload$portlet$PortletFileUpload == null ? (class$org$apache$commons$fileupload$portlet$PortletFileUpload = CommonsPortletMultipartResolver.class$("org.apache.commons.fileupload.portlet.PortletFileUpload")) : class$org$apache$commons$fileupload$portlet$PortletFileUpload), (String)"isMultipartContent", (Class[])new Class[]{class$javax$portlet$ActionRequest == null ? (class$javax$portlet$ActionRequest = CommonsPortletMultipartResolver.class$("javax.portlet.ActionRequest")) : class$javax$portlet$ActionRequest});
    static /* synthetic */ Class class$org$apache$commons$fileupload$portlet$PortletFileUpload;
    static /* synthetic */ Class class$javax$portlet$ActionRequest;

    public CommonsPortletMultipartResolver() {
    }

    public CommonsPortletMultipartResolver(PortletContext portletContext) {
        this();
        this.setPortletContext(portletContext);
    }

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        return new PortletFileUpload(fileItemFactory);
    }

    public void setPortletContext(PortletContext portletContext) {
        if (!this.isUploadTempDirSpecified()) {
            this.getFileItemFactory().setRepository(PortletUtils.getTempDir(portletContext));
        }
    }

    public boolean isMultipart(ActionRequest request) {
        if (this.commonsFileUpload12Present) {
            return PortletFileUpload.isMultipartContent((ActionRequest)request);
        }
        return PortletFileUpload.isMultipartContent((RequestContext)new PortletRequestContext(request));
    }

    public MultipartActionRequest resolveMultipart(ActionRequest request) throws MultipartException {
        String encoding = this.determineEncoding(request);
        FileUpload fileUpload = this.prepareFileUpload(encoding);
        try {
            List fileItems = ((PortletFileUpload)fileUpload).parseRequest(request);
            CommonsFileUploadSupport.MultipartParsingResult parsingResult = this.parseFileItems(fileItems, encoding);
            return new DefaultMultipartActionRequest(request, parsingResult.getMultipartFiles(), parsingResult.getMultipartParameters());
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Could not parse multipart portlet request", (Throwable)ex);
        }
    }

    protected String determineEncoding(ActionRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return encoding;
    }

    public void cleanupMultipart(MultipartActionRequest request) {
        this.cleanupFileItems(request.getFileMap().values());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

