/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.web.client.MockClientHttpResponse;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.util.Assert;

class DefaultResponseCreator
implements ResponseCreator {
    private byte[] body;
    private Resource bodyResource;
    private final HttpHeaders headers = new HttpHeaders();
    private HttpStatus statusCode;

    public DefaultResponseCreator(HttpStatus statusCode) {
        Assert.notNull((Object)statusCode);
        this.statusCode = statusCode;
    }

    public DefaultResponseCreator body(String body) {
        this.body = body.getBytes(Charset.forName("UTF-8"));
        return this;
    }

    public DefaultResponseCreator body(byte[] body) {
        this.body = body;
        return this;
    }

    public DefaultResponseCreator body(Resource bodyResource) {
        this.bodyResource = bodyResource;
        return this;
    }

    public DefaultResponseCreator contentType(MediaType mediaType) {
        if (mediaType != null) {
            this.headers.setContentType(mediaType);
        }
        return this;
    }

    public DefaultResponseCreator location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    public DefaultResponseCreator headers(HttpHeaders headers) {
        for (String headerName : headers.keySet()) {
            for (String headerValue : headers.get((Object)headerName)) {
                this.headers.add(headerName, headerValue);
            }
        }
        return this;
    }

    public ClientHttpResponse createResponse(ClientHttpRequest request) throws IOException {
        if (this.bodyResource != null) {
            InputStream stream = this.bodyResource.getInputStream();
            return new MockClientHttpResponse(stream, this.headers, this.statusCode);
        }
        return new MockClientHttpResponse(this.body, this.headers, this.statusCode);
    }
}

