/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.util.Assert;

public class MockClientHttpRequest
implements ClientHttpRequest,
ResponseActions {
    private final List<RequestMatcher> requestMatchers = new LinkedList<RequestMatcher>();
    private ResponseCreator responseCreator;
    private URI uri;
    private HttpMethod httpMethod;
    private HttpHeaders httpHeaders = new HttpHeaders();
    private ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    void addRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"'requestMatcher' must not be null");
        this.requestMatchers.add(requestMatcher);
    }

    public ResponseActions andExpect(RequestMatcher requestMatcher) {
        this.addRequestMatcher(requestMatcher);
        return this;
    }

    public void andRespond(ResponseCreator responseCreator) {
        Assert.notNull((Object)responseCreator, (String)"'responseCreator' must not be null");
        this.responseCreator = responseCreator;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public OutputStream getBody() throws IOException {
        return this.bodyStream;
    }

    public String getBodyContent() throws IOException {
        return this.bodyStream.toString("UTF-8");
    }

    public ClientHttpResponse execute() throws IOException {
        if (!this.requestMatchers.isEmpty()) {
            for (RequestMatcher requestMatcher : this.requestMatchers) {
                requestMatcher.match(this);
            }
        } else {
            throw new AssertionError((Object)"Unexpected execute()");
        }
        if (this.responseCreator != null) {
            return this.responseCreator.createResponse(this);
        }
        return null;
    }
}

