/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.client.MockClientHttpRequest;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestMatchers {
    private RequestMatchers() {
    }

    public static RequestMatcher anything() {
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
            }
        };
    }

    public static RequestMatcher method(final HttpMethod method) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                AssertionErrors.assertEquals("Unexpected HttpMethod", method, request.getMethod());
            }
        };
    }

    public static RequestMatcher requestTo(final Matcher<String> matcher) {
        Assert.notNull(matcher, (String)"'matcher' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MatcherAssert.assertThat((String)"Request URI", (Object)request.getURI().toString(), (Matcher)matcher);
            }
        };
    }

    public static RequestMatcher requestTo(String uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return RequestMatchers.requestTo((Matcher<String>)Matchers.equalTo((Object)uri));
    }

    public static RequestMatcher requestTo(final URI uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                AssertionErrors.assertEquals("Unexpected request", uri, request.getURI());
            }
        };
    }

    public static RequestMatcher header(final String header, final String ... values) {
        Assert.notNull((Object)header, (String)"'header' must not be null");
        Assert.notEmpty((Object[])values, (String)"'values' must not be empty");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                List actual = request.getHeaders().get((Object)header);
                AssertionErrors.assertTrue("Expected header <" + header + "> in request", actual != null);
                for (String value : values) {
                    AssertionErrors.assertTrue("Expected value <" + value + "> in header <" + header + ">", actual.contains(value));
                }
            }
        };
    }

    public static RequestMatcher headerContains(final String header, final String substring) {
        Assert.notNull((Object)header, (String)"'header' must not be null");
        Assert.notNull((Object)substring, (String)"'substring' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                List actualHeaders = request.getHeaders().get((Object)header);
                AssertionErrors.assertTrue("Expected header <" + header + "> in request", actualHeaders != null);
                boolean foundMatch = false;
                for (String headerValue : actualHeaders) {
                    if (!headerValue.contains(substring)) continue;
                    foundMatch = true;
                    break;
                }
                AssertionErrors.assertTrue("Expected value containing <" + substring + "> in header <" + header + ">", foundMatch);
            }
        };
    }

    public static RequestMatcher body(final String body) {
        Assert.notNull((Object)body, (String)"'body' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError, IOException {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                AssertionErrors.assertEquals("Unexpected body content", body, mockRequest.getBodyContent());
            }
        };
    }
}

