/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.request;

import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.server.RequestBuilder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequestBuilder
implements RequestBuilder {
    private final URI uri;
    private final HttpMethod method;
    private final MultiValueMap<String, String> parameters = new LinkedMultiValueMap();
    private final MultiValueMap<String, Object> headers = new LinkedMultiValueMap();
    private final HttpHeaders httpHeaders = new HttpHeaders();
    private String contentType;
    private byte[] requestBody;
    private Cookie[] cookies;
    private Locale locale;
    private String characterEncoding;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();
    private Principal principal;
    private String contextPath = "";
    private String servletPath = "";
    private boolean secure = false;

    DefaultRequestBuilder(URI uri, HttpMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public DefaultRequestBuilder param(String name, String value, String ... values) {
        DefaultRequestBuilder.addToMultiValueMap(this.parameters, name, value, values);
        return this;
    }

    public DefaultRequestBuilder accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"No 'Accept' media types");
        this.headers.set((Object)"Accept", (Object)MediaType.toString(Arrays.asList(mediaTypes)));
        return this;
    }

    public DefaultRequestBuilder contentType(MediaType mediaType) {
        Assert.notNull((Object)mediaType, (String)"'mediaType' must not be null");
        this.contentType = mediaType.toString();
        this.headers.set((Object)"Content-Type", (Object)this.contentType);
        return this;
    }

    public DefaultRequestBuilder body(byte[] requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public DefaultRequestBuilder header(String name, Object value, Object ... values) {
        DefaultRequestBuilder.addToMultiValueMap(this.headers, name, value, values);
        return this;
    }

    public DefaultRequestBuilder headers(HttpHeaders httpHeaders) {
        this.httpHeaders.putAll((Map)httpHeaders);
        return this;
    }

    public DefaultRequestBuilder cookie(Cookie cookie, Cookie ... cookies) {
        Assert.notNull((Object)cookie, (String)"'cookie' must not be null");
        if (cookies == null) {
            this.cookies = new Cookie[]{cookie};
        } else {
            this.cookies = new Cookie[1 + cookies.length];
            this.cookies[0] = cookie;
            System.arraycopy(cookies, 0, this.cookies, 1, cookies.length);
        }
        return this;
    }

    public DefaultRequestBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public DefaultRequestBuilder characterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
        return this;
    }

    public DefaultRequestBuilder requestAttr(String name, Object value) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        this.attributes.put(name, value);
        return this;
    }

    public DefaultRequestBuilder sessionAttr(String name, Object value) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        this.sessionAttributes.put(name, value);
        return this;
    }

    public DefaultRequestBuilder principal(Principal principal) {
        Assert.notNull((Object)principal, (String)"'principal' must not be null");
        this.principal = principal;
        return this;
    }

    public DefaultRequestBuilder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public DefaultRequestBuilder servletPath(String servletPath) {
        this.servletPath = servletPath;
        return this;
    }

    public DefaultRequestBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public MockHttpServletRequest buildRequest(ServletContext servletContext) {
        MockHttpServletRequest request = this.createServletRequest(servletContext);
        request.setMethod(this.method.name());
        String requestUri = UriComponentsBuilder.fromUri((URI)this.uri).query(null).fragment(null).build().toString();
        request.setRequestURI(requestUri);
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)this.uri).build();
        String queryString = uriComponents.getQuery();
        request.setQueryString(queryString);
        MultiValueMap queryParams = uriComponents.getQueryParams();
        for (String name : queryParams.keySet()) {
            for (String value : (List)queryParams.get((Object)name)) {
                request.addParameter(name, value);
            }
        }
        for (String name : this.parameters.keySet()) {
            for (String value : (List)this.parameters.get((Object)name)) {
                request.addParameter(name, value);
            }
        }
        for (String name : this.headers.keySet()) {
            for (String value : (List)this.headers.get((Object)name)) {
                request.addHeader(name, (Object)value);
            }
        }
        for (String name : this.httpHeaders.keySet()) {
            for (String value : this.httpHeaders.get((Object)name)) {
                request.addHeader(name, (Object)value);
            }
        }
        for (String name : this.attributes.keySet()) {
            request.setAttribute(name, this.attributes.get(name));
        }
        for (String name : this.sessionAttributes.keySet()) {
            request.getSession().setAttribute(name, this.sessionAttributes.get(name));
        }
        request.setContentType(this.contentType);
        request.setContent(this.requestBody);
        request.setCookies(this.cookies);
        request.setCharacterEncoding(this.characterEncoding);
        request.setUserPrincipal(this.principal);
        request.setContextPath(this.contextPath);
        request.setServletPath(this.servletPath);
        request.setPathInfo(this.determinePathInfo());
        request.setSecure(this.secure);
        if (this.locale != null) {
            request.addPreferredLocale(this.locale);
        }
        return request;
    }

    protected MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        return new MockHttpServletRequest(servletContext);
    }

    private String determinePathInfo() {
        String uriString = this.uri.toString();
        String prefix = "";
        if (StringUtils.hasText((String)this.contextPath)) {
            prefix = prefix + this.contextPath;
            Assert.isTrue((boolean)uriString.startsWith(prefix), (String)("The URI '" + uriString + "' must start with the contextPath='" + prefix + "'"));
        }
        if (StringUtils.hasText((String)this.servletPath)) {
            prefix = prefix + this.servletPath;
            Assert.isTrue((boolean)uriString.startsWith(prefix), (String)("The URI '" + uriString + "' must start with the combined contextPath and servletPath '" + prefix + "'"));
        }
        return uriString.substring(prefix.length());
    }

    private static <T> void addToMultiValueMap(MultiValueMap<String, T> map, String name, T value, T[] values) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull(value, (String)"'value' must not be null");
        map.add((Object)name, value);
        if (values != null) {
            ((List)map.get((Object)name)).addAll(Arrays.asList(values));
        }
    }
}

