/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.request;

import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.test.web.server.request.DefaultRequestBuilder;
import org.springframework.test.web.server.request.MultipartRequestBuilder;
import org.springframework.web.util.UriTemplate;

public abstract class MockMvcRequestBuilders {
    private MockMvcRequestBuilders() {
    }

    public static DefaultRequestBuilder get(String urlTemplate, Object ... urlVariables) {
        return MockMvcRequestBuilders.request(HttpMethod.GET, urlTemplate, urlVariables);
    }

    public static DefaultRequestBuilder post(String urlTemplate, Object ... urlVariables) {
        return MockMvcRequestBuilders.request(HttpMethod.POST, urlTemplate, urlVariables);
    }

    public static DefaultRequestBuilder put(String urlTemplate, Object ... urlVariables) {
        return MockMvcRequestBuilders.request(HttpMethod.PUT, urlTemplate, urlVariables);
    }

    public static DefaultRequestBuilder delete(String urlTemplate, Object ... urlVariables) {
        return MockMvcRequestBuilders.request(HttpMethod.DELETE, urlTemplate, urlVariables);
    }

    public static MultipartRequestBuilder fileUpload(String urlTemplate, Object ... urlVariables) {
        URI url = MockMvcRequestBuilders.expandUrl(urlTemplate, urlVariables);
        return new MultipartRequestBuilder(url);
    }

    public static DefaultRequestBuilder request(HttpMethod method, String urlTemplate, Object ... urlVariables) {
        URI url = MockMvcRequestBuilders.expandUrl(urlTemplate, urlVariables);
        return new DefaultRequestBuilder(url, method);
    }

    private static URI expandUrl(String urlTemplate, Object[] urlVariables) {
        UriTemplate uriTemplate = new UriTemplate(urlTemplate);
        return uriTemplate.expand(urlVariables);
    }
}

