/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.request;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.test.web.server.request.DefaultRequestBuilder;
import org.springframework.web.multipart.MultipartFile;

public class MultipartRequestBuilder
extends DefaultRequestBuilder {
    private final List<MockMultipartFile> files = new ArrayList<MockMultipartFile>();

    MultipartRequestBuilder(URI uri) {
        super(uri, HttpMethod.POST);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    public MultipartRequestBuilder file(String name, byte[] content) {
        this.files.add(new MockMultipartFile(name, content));
        return this;
    }

    public MultipartRequestBuilder file(MockMultipartFile file) {
        this.files.add(file);
        return this;
    }

    protected final MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        MockMultipartHttpServletRequest request = new MockMultipartHttpServletRequest();
        for (MockMultipartFile file : this.files) {
            request.addFile((MultipartFile)file);
        }
        return request;
    }
}

