/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.web.server.setup.AbstractMockMvcBuilder;
import org.springframework.test.web.server.setup.StubWebApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.Validator;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.view.DefaultRequestToViewNameTranslator;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneMockMvcBuilder
extends AbstractMockMvcBuilder {
    private final Object[] controllers;
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private List<HandlerMethodReturnValueHandler> customReturnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
    private final List<MappedInterceptor> mappedInterceptors = new ArrayList<MappedInterceptor>();
    private Validator validator = null;
    private FormattingConversionService conversionService = null;
    private List<HandlerExceptionResolver> handlerExceptionResolvers = new ArrayList<HandlerExceptionResolver>();
    private List<ViewResolver> viewResolvers;
    private LocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
    private FlashMapManager flashMapManager = null;

    protected StandaloneMockMvcBuilder(Object[] controllers) {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])controllers) ? 1 : 0) != 0, (String)"At least one controller is required");
        this.controllers = controllers;
    }

    public StandaloneMockMvcBuilder setMessageConverters(HttpMessageConverter<?> ... messageConverters) {
        this.messageConverters = Arrays.asList(messageConverters);
        return this;
    }

    public StandaloneMockMvcBuilder setValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public StandaloneMockMvcBuilder setConversionService(FormattingConversionService conversionService) {
        this.conversionService = conversionService;
        return this;
    }

    public StandaloneMockMvcBuilder addInterceptors(HandlerInterceptor ... interceptors) {
        this.addMappedInterceptors(null, interceptors);
        return this;
    }

    public StandaloneMockMvcBuilder addMappedInterceptors(String[] pathPatterns, HandlerInterceptor ... interceptors) {
        for (HandlerInterceptor interceptor : interceptors) {
            this.mappedInterceptors.add(new MappedInterceptor(pathPatterns, interceptor));
        }
        return this;
    }

    public StandaloneMockMvcBuilder setCustomArgumentResolvers(HandlerMethodArgumentResolver ... argumentResolvers) {
        this.customArgumentResolvers = Arrays.asList(argumentResolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setCustomReturnValueHandlers(HandlerMethodReturnValueHandler ... handlers) {
        this.customReturnValueHandlers = Arrays.asList(handlers);
        return this;
    }

    public void setHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        this.handlerExceptionResolvers = exceptionResolvers;
    }

    public StandaloneMockMvcBuilder setViewResolvers(ViewResolver ... resolvers) {
        this.viewResolvers = Arrays.asList(resolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setSingleView(View view) {
        this.viewResolvers = Collections.singletonList(new StubViewResolver(view));
        return this;
    }

    public StandaloneMockMvcBuilder setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
        return this;
    }

    public StandaloneMockMvcBuilder setFlashMapManager(FlashMapManager flashMapManager) {
        this.flashMapManager = flashMapManager;
        return this;
    }

    @Override
    protected ServletContext initServletContext() {
        return new MockServletContext();
    }

    @Override
    protected WebApplicationContext initWebApplicationContext(ServletContext servletContext) {
        StubWebApplicationContext wac = new StubWebApplicationContext(servletContext);
        this.registerMvcSingletons(wac);
        return wac;
    }

    private void registerMvcSingletons(StubWebApplicationContext wac) {
        WebMvcConfig config = new WebMvcConfig();
        RequestMappingHandlerMapping handlerMapping = config.requestMappingHandlerMapping();
        this.extendRequestMappingHandlerMapping(handlerMapping);
        handlerMapping.setServletContext(wac.getServletContext());
        handlerMapping.setApplicationContext((ApplicationContext)wac);
        wac.addBean("requestMappingHandlerMapping", handlerMapping);
        RequestMappingHandlerAdapter handlerAdapter = config.requestMappingHandlerAdapter();
        this.extendRequestMappingHandlerAdapter(handlerAdapter);
        handlerAdapter.setServletContext(wac.getServletContext());
        handlerAdapter.setApplicationContext((ApplicationContext)wac);
        handlerAdapter.afterPropertiesSet();
        wac.addBean("requestMappingHandlerAdapter", handlerAdapter);
        wac.addBean("handlerExceptionResolver", config.handlerExceptionResolver());
        wac.addBeans(this.initViewResolvers(wac));
        wac.addBean("localeResolver", this.localeResolver);
        wac.addBean("themeResolver", new FixedThemeResolver());
        wac.addBean("viewNameTranslator", new DefaultRequestToViewNameTranslator());
        if (this.flashMapManager == null) {
            this.initFlashMapManager();
        }
        wac.addBean("flashMapManager", this.flashMapManager);
    }

    private void initFlashMapManager() {
        String className = "org.springframework.web.servlet.support.DefaultFlashMapManager";
        if (ClassUtils.isPresent((String)className, (ClassLoader)this.getClass().getClassLoader())) {
            this.flashMapManager = (FlashMapManager)this.instantiateClass(className);
        } else {
            className = "org.springframework.web.servlet.support.SessionFlashMapManager";
            this.flashMapManager = (FlashMapManager)this.instantiateClass(className);
        }
    }

    private <T> T instantiateClass(String className) {
        Class clazz;
        try {
            clazz = ClassUtils.forName((String)className, (ClassLoader)StandaloneMockMvcBuilder.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new BeanInitializationException("Could not instantiate " + className, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new BeanInitializationException("Could not instantiate " + className, (Throwable)e);
        }
        return (T)BeanUtils.instantiate((Class)clazz);
    }

    protected void extendRequestMappingHandlerMapping(RequestMappingHandlerMapping handlerMapping) {
    }

    protected void extendRequestMappingHandlerAdapter(RequestMappingHandlerAdapter handlerAdapter) {
    }

    private List<ViewResolver> initViewResolvers(WebApplicationContext wac) {
        this.viewResolvers = this.viewResolvers == null ? Arrays.asList(new InternalResourceViewResolver()) : this.viewResolvers;
        for (ViewResolver viewResolver : this.viewResolvers) {
            if (!(viewResolver instanceof WebApplicationObjectSupport)) continue;
            ((WebApplicationObjectSupport)viewResolver).setApplicationContext((ApplicationContext)wac);
        }
        return this.viewResolvers;
    }

    private static class StubViewResolver
    implements ViewResolver {
        private final View view;

        public StubViewResolver(View view) {
            this.view = view;
        }

        public View resolveViewName(String viewName, Locale locale) throws Exception {
            return this.view;
        }
    }

    private static class StaticRequestMappingHandlerMapping
    extends RequestMappingHandlerMapping {
        private StaticRequestMappingHandlerMapping() {
        }

        public void registerHandlers(Object ... handlers) {
            for (Object handler : handlers) {
                super.detectHandlerMethods(handler);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebMvcConfig
    extends WebMvcConfigurationSupport {
        private WebMvcConfig() {
        }

        public RequestMappingHandlerMapping requestMappingHandlerMapping() {
            StaticRequestMappingHandlerMapping handlerMapping = new StaticRequestMappingHandlerMapping();
            handlerMapping.registerHandlers(StandaloneMockMvcBuilder.this.controllers);
            handlerMapping.setOrder(0);
            handlerMapping.setInterceptors(this.getInterceptors());
            return handlerMapping;
        }

        protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.addAll(StandaloneMockMvcBuilder.this.messageConverters);
        }

        protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.addAll(StandaloneMockMvcBuilder.this.customArgumentResolvers);
        }

        protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
            returnValueHandlers.addAll(StandaloneMockMvcBuilder.this.customReturnValueHandlers);
        }

        protected void addInterceptors(InterceptorRegistry registry) {
            for (MappedInterceptor interceptor : StandaloneMockMvcBuilder.this.mappedInterceptors) {
                InterceptorRegistration registration = registry.addInterceptor(interceptor.getInterceptor());
                if (interceptor.getPathPatterns() == null) continue;
                registration.addPathPatterns(interceptor.getPathPatterns());
            }
        }

        public FormattingConversionService mvcConversionService() {
            FormattingConversionService mvcConversionService = StandaloneMockMvcBuilder.this.conversionService != null ? StandaloneMockMvcBuilder.this.conversionService : super.mvcConversionService();
            return mvcConversionService == null ? super.mvcConversionService() : mvcConversionService;
        }

        public Validator mvcValidator() {
            Validator mvcValidator;
            Validator validator = mvcValidator = StandaloneMockMvcBuilder.this.validator != null ? StandaloneMockMvcBuilder.this.validator : super.mvcValidator();
            if (mvcValidator instanceof InitializingBean) {
                try {
                    ((InitializingBean)mvcValidator).afterPropertiesSet();
                }
                catch (Exception e) {
                    throw new BeanInitializationException("Failed to initialize Validator", (Throwable)e);
                }
            }
            return mvcValidator;
        }

        protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
            exceptionResolvers.addAll(StandaloneMockMvcBuilder.this.handlerExceptionResolvers);
        }
    }
}

