/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.support;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.web.AssertionErrors;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlExpectationsHelper {
    public void assertNode(String content, Matcher<? super Node> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        MatcherAssert.assertThat((String)"Contents", (Object)document, matcher);
    }

    protected Document parseXmlString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xml));
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    public void assertSource(String content, Matcher<? super Source> matcher) throws Exception {
        Document document = this.parseXmlString(content);
        MatcherAssert.assertThat((String)"Contents", (Object)new DOMSource(document), matcher);
    }

    public void assertXmlEqual(String expected, String actual) throws Exception {
        Document test;
        Document control = XMLUnit.buildControlDocument((String)expected);
        Diff diff = new Diff(control, test = XMLUnit.buildTestDocument((String)actual));
        if (!diff.similar()) {
            AssertionErrors.fail("Contents " + diff.toString());
        }
    }
}

