/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.util.Assert;

class RequestMatcherClientHttpRequest
extends MockClientHttpRequest
implements ResponseActions {
    private final List<RequestMatcher> requestMatchers = new LinkedList<RequestMatcher>();
    private ResponseCreator responseCreator;

    public RequestMatcherClientHttpRequest(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"RequestMatcher is required");
        this.requestMatchers.add(requestMatcher);
    }

    public ResponseActions andExpect(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"RequestMatcher is required");
        this.requestMatchers.add(requestMatcher);
        return this;
    }

    public void andRespond(ResponseCreator responseCreator) {
        Assert.notNull((Object)responseCreator, (String)"ResponseCreator is required");
        this.responseCreator = responseCreator;
    }

    public ClientHttpResponse execute() throws IOException {
        if (this.requestMatchers.isEmpty()) {
            throw new AssertionError((Object)"No request expectations to execute");
        }
        if (this.responseCreator == null) {
            throw new AssertionError((Object)"No ResponseCreator was set up. Add it after request expectations, e.g. MockRestServiceServer.expect(requestTo(\"/foo\")).andRespond(withSuccess())");
        }
        for (RequestMatcher requestMatcher : this.requestMatchers) {
            requestMatcher.match(this);
        }
        this.setResponse(this.responseCreator.createResponse(this));
        return super.execute();
    }
}

