/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.result;

import javax.servlet.http.Cookie;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.server.MvcResult;
import org.springframework.test.web.server.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieResultMatchers {
    protected CookieResultMatchers() {
    }

    public ResultMatcher value(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("Response cookie not found: " + name, cookie != null);
                MatcherAssert.assertThat((String)"Response cookie", (Object)cookie.getValue(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher value(String name, String value) {
        return this.value(name, (Matcher<? super String>)Matchers.equalTo((Object)value));
    }

    public ResultMatcher exists(final String name) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("No cookie with name: " + name, cookie != null);
            }
        };
    }

    public ResultMatcher doesNotExist(final String name) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("Unexpected cookie with name " + name, cookie == null);
            }
        };
    }

    public ResultMatcher maxAge(final String name, final Matcher<? super Integer> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertTrue("No cookie with name: " + name, cookie != null);
                MatcherAssert.assertThat((String)"Response cookie maxAge", (Object)cookie.getMaxAge(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher maxAge(String name, int maxAge) {
        return this.maxAge(name, (Matcher<? super Integer>)Matchers.equalTo((Object)maxAge));
    }

    public ResultMatcher path(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                MatcherAssert.assertThat((String)"Response cookie path", (Object)cookie.getPath(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher path(String name, String path) {
        return this.path(name, (Matcher<? super String>)Matchers.equalTo((Object)path));
    }

    public ResultMatcher domain(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                MatcherAssert.assertThat((String)"Response cookie domain", (Object)cookie.getDomain(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher domain(String name, String domain) {
        return this.domain(name, (Matcher<? super String>)Matchers.equalTo((Object)domain));
    }

    public ResultMatcher comment(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                MatcherAssert.assertThat((String)"Response cookie comment", (Object)cookie.getComment(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher comment(String name, String comment) {
        return this.comment(name, (Matcher<? super String>)Matchers.equalTo((Object)comment));
    }

    public ResultMatcher version(final String name, final Matcher<? super Integer> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                MatcherAssert.assertThat((String)"Response cookie version", (Object)cookie.getVersion(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher version(String name, int version) {
        return this.version(name, (Matcher<? super Integer>)Matchers.equalTo((Object)version));
    }

    public ResultMatcher secure(final String name, final boolean secure) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Cookie cookie = result.getResponse().getCookie(name);
                AssertionErrors.assertEquals("Response cookie secure", secure, cookie.getSecure());
            }
        };
    }
}

