/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.test.web.server.MvcResult;
import org.springframework.test.web.server.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestResultMatchers {
    protected RequestResultMatchers() {
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Object value = result.getRequest().getAttribute(name);
                MatcherAssert.assertThat((String)"Request attribute: ", (Object)value, (Matcher)matcher);
            }
        };
    }

    public <T> ResultMatcher attribute(String name, Object value) {
        return this.attribute(name, Matchers.equalTo((Object)value));
    }

    public <T> ResultMatcher sessionAttribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Object value = result.getRequest().getSession().getAttribute(name);
                MatcherAssert.assertThat((String)"Request attribute: ", (Object)value, (Matcher)matcher);
            }
        };
    }

    public <T> ResultMatcher sessionAttribute(String name, Object value) {
        return this.sessionAttribute(name, Matchers.equalTo((Object)value));
    }
}

