/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.setup;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.test.web.server.MockMvc;
import org.springframework.test.web.server.MockMvcBuilder;
import org.springframework.test.web.server.MockMvcBuilderSupport;
import org.springframework.test.web.server.RequestBuilder;
import org.springframework.test.web.server.ResultHandler;
import org.springframework.test.web.server.ResultMatcher;
import org.springframework.test.web.server.setup.PatternMappingFilterProxy;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMockMvcBuilder<Self extends AbstractMockMvcBuilder<Self>>
extends MockMvcBuilderSupport
implements MockMvcBuilder {
    private List<Filter> filters = new ArrayList<Filter>();
    private RequestBuilder defaultRequestBuilder;
    private final List<ResultMatcher> globalResultMatchers = new ArrayList<ResultMatcher>();
    private final List<ResultHandler> globalResultHandlers = new ArrayList<ResultHandler>();

    public final <T extends Self> T addFilters(Filter ... filters) {
        Assert.notNull((Object)filters, (String)"filters cannot be null");
        for (Filter f : filters) {
            Assert.notNull((Object)f, (String)"filters cannot contain null values");
            this.filters.add(f);
        }
        return (T)this;
    }

    public final <T extends Self> T addFilter(Filter filter, String ... urlPatterns) {
        Assert.notNull((Object)filter, (String)"filter cannot be null");
        Assert.notNull((Object)urlPatterns, (String)"urlPatterns cannot be null");
        if (urlPatterns.length > 0) {
            filter = new PatternMappingFilterProxy(filter, urlPatterns);
        }
        this.filters.add(filter);
        return (T)this;
    }

    public final <T extends Self> T defaultRequest(RequestBuilder requestBuilder) {
        this.defaultRequestBuilder = requestBuilder;
        return (T)this;
    }

    public final <T extends Self> T alwaysExpect(ResultMatcher resultMatcher) {
        this.globalResultMatchers.add(resultMatcher);
        return (T)this;
    }

    public final <T extends Self> T alwaysDo(ResultHandler resultHandler) {
        this.globalResultHandlers.add(resultHandler);
        return (T)this;
    }

    @Override
    public final MockMvc build() {
        WebApplicationContext webAppContext = this.initWebApplicationContext();
        Assert.state((webAppContext != null ? 1 : 0) != 0, (String)"WebApplicationContext not provided by concrete MockMvcBuilder");
        ServletContext servletContext = webAppContext.getServletContext();
        Assert.state((servletContext != null ? 1 : 0) != 0, (String)"ServletContext not configured by concrete MockMvcBuilder");
        Filter[] filterArray = this.filters.toArray(new Filter[this.filters.size()]);
        MockServletConfig mockServletConfig = new MockServletConfig(servletContext);
        return super.createMockMvc(filterArray, mockServletConfig, webAppContext, this.defaultRequestBuilder, this.globalResultMatchers, this.globalResultHandlers);
    }

    protected abstract WebApplicationContext initWebApplicationContext();
}

