/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.support;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import java.text.ParseException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.test.web.AssertionErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPathExpectationsHelper {
    private final String expression;
    private final JsonPath jsonPath;

    public JsonPathExpectationsHelper(String expression, Object ... args) {
        this.expression = String.format(expression, args);
        this.jsonPath = JsonPath.compile((String)this.expression, (Filter[])new Filter[0]);
    }

    public <T> void assertValue(String content, Matcher<T> matcher) throws ParseException {
        Object value = this.evaluateJsonPath(content);
        MatcherAssert.assertThat((String)("JSON path: " + this.expression), (Object)value, matcher);
    }

    private Object evaluateJsonPath(String content) throws ParseException {
        String message = "No value for JSON path: " + this.expression + ", exception: ";
        try {
            return this.jsonPath.read(content);
        }
        catch (InvalidPathException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
    }

    public void assertValue(Object value) throws ParseException {
        this.assertValue(Matchers.equalTo((Object)value));
    }

    public void exists(String content) throws ParseException {
        Object value = this.evaluateJsonPath(content);
        String reason = "No value for JSON path: " + this.expression;
        AssertionErrors.assertTrue(reason, value != null);
        if (List.class.isInstance(value)) {
            AssertionErrors.assertTrue(reason, !((List)value).isEmpty());
        }
    }

    public void doesNotExist(String content) throws ParseException {
        Object value;
        try {
            value = this.evaluateJsonPath(content);
        }
        catch (AssertionError ex) {
            return;
        }
        String reason = String.format("Expected no value for JSON path: %s but found: %s", this.expression, value);
        if (List.class.isInstance(value)) {
            AssertionErrors.assertTrue(reason, ((List)value).isEmpty());
        } else {
            AssertionErrors.assertTrue(reason, value == null);
        }
    }
}

