/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.match.ContentRequestMatchers;
import org.springframework.test.web.client.match.JsonPathRequestMatchers;
import org.springframework.test.web.client.match.XpathRequestMatchers;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockRestRequestMatchers {
    private MockRestRequestMatchers() {
    }

    public static RequestMatcher anything() {
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
            }
        };
    }

    public static RequestMatcher requestTo(final Matcher<String> matcher) {
        Assert.notNull(matcher, (String)"'matcher' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MatcherAssertionErrors.assertThat("Request URI", request.getURI().toString(), matcher);
            }
        };
    }

    public static RequestMatcher requestTo(String uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return MockRestRequestMatchers.requestTo((Matcher<String>)Matchers.equalTo((Object)uri));
    }

    public static RequestMatcher method(final HttpMethod method) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                AssertionErrors.assertEquals("Unexpected HttpMethod", method, request.getMethod());
            }
        };
    }

    public static RequestMatcher requestTo(final URI uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                AssertionErrors.assertEquals("Unexpected request", uri, request.getURI());
            }
        };
    }

    public static RequestMatcher header(final String name, final Matcher<? super String> ... matchers) {
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) {
                HttpHeaders headers = request.getHeaders();
                List values = headers.get((Object)name);
                AssertionErrors.assertTrue("Expected header <" + name + ">", values != null);
                AssertionErrors.assertTrue("Expected header <" + name + "> to have at least <" + matchers.length + "> values but it has only <" + values.size() + ">", matchers.length <= values.size());
                for (int i = 0; i < matchers.length; ++i) {
                    MatcherAssertionErrors.assertThat("Request header", headers.get((Object)name).get(i), matchers[i]);
                }
            }
        };
    }

    public static RequestMatcher header(String name, String ... values) {
        IsEqual[] matchers = new IsEqual[values.length];
        for (int i = 0; i < values.length; ++i) {
            matchers[i] = Matchers.equalTo((Object)values[i]);
        }
        return MockRestRequestMatchers.header(name, matchers);
    }

    public static ContentRequestMatchers content() {
        return new ContentRequestMatchers();
    }

    public static JsonPathRequestMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathRequestMatchers(expression, args);
    }

    public static <T> RequestMatcher jsonPath(String expression, Matcher<T> matcher) {
        return new JsonPathRequestMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathRequestMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, null, args);
    }

    public static XpathRequestMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, namespaces, args);
    }
}

