/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.XpathExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpathRequestMatchers {
    private final XpathExpectationsHelper xpathHelper;

    protected XpathRequestMatchers(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.xpathHelper = new XpathExpectationsHelper(expression, namespaces, args);
    }

    public <T> RequestMatcher node(final Matcher<? super Node> matcher) {
        return new AbstractXpathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertNode(request.getBodyAsString(), (Matcher<? super Node>)matcher);
            }
        };
    }

    public <T> RequestMatcher exists() {
        return this.node((Matcher<? super Node>)Matchers.notNullValue());
    }

    public <T> RequestMatcher doesNotExist() {
        return this.node((Matcher<? super Node>)Matchers.nullValue());
    }

    public <T> RequestMatcher nodeCount(final Matcher<Integer> matcher) {
        return new AbstractXpathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertNodeCount(request.getBodyAsString(), (Matcher<Integer>)matcher);
            }
        };
    }

    public <T> RequestMatcher nodeCount(int expectedCount) {
        return this.nodeCount((Matcher<Integer>)Matchers.equalTo((Object)expectedCount));
    }

    public <T> RequestMatcher string(final Matcher<? super String> matcher) {
        return new AbstractXpathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertString(request.getBodyAsString(), (Matcher<? super String>)matcher);
            }
        };
    }

    public RequestMatcher string(String value) {
        return this.string((Matcher<? super String>)Matchers.equalTo((Object)value));
    }

    public <T> RequestMatcher number(final Matcher<? super Double> matcher) {
        return new AbstractXpathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertNumber(request.getBodyAsString(), (Matcher<? super Double>)matcher);
            }
        };
    }

    public RequestMatcher number(Double value) {
        return this.number((Matcher<? super Double>)Matchers.equalTo((Object)value));
    }

    public <T> RequestMatcher booleanValue(final Boolean value) {
        return new AbstractXpathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                XpathRequestMatchers.this.xpathHelper.assertBoolean(request.getBodyAsString(), value);
            }
        };
    }

    private static abstract class AbstractXpathRequestMatcher
    implements RequestMatcher {
        private AbstractXpathRequestMatcher() {
        }

        public final void match(ClientHttpRequest request) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                this.matchInternal(mockRequest);
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Failed to parse XML request content: " + e.getMessage()));
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws Exception;
    }
}

