/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestResultMatchers {
    protected RequestResultMatchers() {
    }

    public ResultMatcher asyncStarted() {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                MatcherAssertionErrors.assertThat("Async started", request.isAsyncStarted(), Matchers.equalTo((Object)true));
            }
        };
    }

    public ResultMatcher asyncNotStarted() {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                MatcherAssertionErrors.assertThat("Async started", request.isAsyncStarted(), Matchers.equalTo((Object)false));
            }
        };
    }

    public <T> ResultMatcher asyncResult(final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                MatcherAssertionErrors.assertThat("Async started", request.isAsyncStarted(), Matchers.equalTo((Object)true));
                MatcherAssertionErrors.assertThat("Async result", result.getAsyncResult(), matcher);
            }
        };
    }

    public <T> ResultMatcher asyncResult(Object expectedResult) {
        return this.asyncResult(Matchers.equalTo((Object)expectedResult));
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Object value = result.getRequest().getAttribute(name);
                MatcherAssertionErrors.assertThat("Request attribute: ", value, matcher);
            }
        };
    }

    public <T> ResultMatcher attribute(String name, Object value) {
        return this.attribute(name, Matchers.equalTo((Object)value));
    }

    public <T> ResultMatcher sessionAttribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                Object value = result.getRequest().getSession().getAttribute(name);
                MatcherAssertionErrors.assertThat("Request attribute: ", value, matcher);
            }
        };
    }

    public <T> ResultMatcher sessionAttribute(String name, Object value) {
        return this.sessionAttribute(name, Matchers.equalTo((Object)value));
    }
}

