/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ContextLoaderUtils {
    private static final Log logger = LogFactory.getLog(ContextLoaderUtils.class);
    private static final String DEFAULT_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.support.DelegatingSmartContextLoader";
    private static final String DEFAULT_WEB_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.web.WebDelegatingSmartContextLoader";
    private static final String WEB_APP_CONFIGURATION_CLASS_NAME = "org.springframework.test.context.web.WebAppConfiguration";
    private static final String WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME = "org.springframework.test.context.web.WebMergedContextConfiguration";

    private ContextLoaderUtils() {
    }

    static ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, String defaultContextLoaderClassName) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        if (!StringUtils.hasText((String)defaultContextLoaderClassName)) {
            Class<? extends Annotation> webAppConfigClass = ContextLoaderUtils.loadWebAppConfigurationClass();
            defaultContextLoaderClassName = webAppConfigClass != null && testClass.isAnnotationPresent(webAppConfigClass) ? DEFAULT_WEB_CONTEXT_LOADER_CLASS_NAME : DEFAULT_CONTEXT_LOADER_CLASS_NAME;
        }
        Class<? extends ContextLoader> contextLoaderClass = ContextLoaderUtils.resolveContextLoaderClass(testClass, configAttributesList, defaultContextLoaderClassName);
        return (ContextLoader)BeanUtils.instantiateClass(contextLoaderClass, ContextLoader.class);
    }

    static Class<? extends ContextLoader> resolveContextLoaderClass(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, String defaultContextLoaderClassName) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        Assert.hasText((String)defaultContextLoaderClassName, (String)"Default ContextLoader class name must not be null or empty");
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            Class<? extends ContextLoader> contextLoaderClass;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing ContextLoader for context configuration attributes %s", configAttributes));
            }
            if (ContextLoader.class.equals(contextLoaderClass = configAttributes.getContextLoaderClass())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Found explicit ContextLoader class [%s] for context configuration attributes %s", contextLoaderClass.getName(), configAttributes));
            }
            return contextLoaderClass;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Using default ContextLoader class [%s] for test class [%s]", defaultContextLoaderClassName, testClass.getName()));
            }
            return ClassUtils.forName((String)defaultContextLoaderClassName, (ClassLoader)ContextLoaderUtils.class.getClassLoader());
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not load default ContextLoader class [" + defaultContextLoaderClassName + "]. Specify @ContextConfiguration's 'loader' " + "attribute or make the default loader class available.", t);
        }
    }

    static List<ContextConfigurationAttributes> resolveContextConfigurationAttributes(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        ArrayList<ContextConfigurationAttributes> attributesList = new ArrayList<ContextConfigurationAttributes>();
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, testClass);
        Assert.notNull((Object)declaringClass, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        while (declaringClass != null) {
            ContextConfiguration contextConfiguration = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ContextConfiguration [%s] for declaring class [%s].", contextConfiguration, declaringClass.getName()));
            }
            ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(declaringClass, contextConfiguration);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Resolved context configuration attributes: " + attributes));
            }
            attributesList.add(attributes);
            declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass());
        }
        return attributesList;
    }

    static Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> resolveInitializerClasses(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        HashSet<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses = new HashSet<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>>();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing context initializers for context configuration attributes %s", configAttributes));
            }
            initializerClasses.addAll(Arrays.asList(configAttributes.getInitializers()));
            if (configAttributes.isInheritInitializers()) continue;
            break;
        }
        return initializerClasses;
    }

    static String[] resolveActiveProfiles(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, testClass);
        if (declaringClass == null && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        }
        HashSet<String> activeProfiles = new HashSet<String>();
        while (declaringClass != null) {
            ActiveProfiles annotation = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ActiveProfiles [%s] for declaring class [%s].", annotation, declaringClass.getName()));
            }
            Object[] profiles = annotation.profiles();
            Object[] valueProfiles = annotation.value();
            if (!ObjectUtils.isEmpty((Object[])valueProfiles) && !ObjectUtils.isEmpty((Object[])profiles)) {
                String msg = String.format("Test class [%s] has been configured with @ActiveProfiles' 'value' [%s] and 'profiles' [%s] attributes. Only one declaration of active bean definition profiles is permitted per @ActiveProfiles annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])valueProfiles), ObjectUtils.nullSafeToString((Object[])profiles));
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            if (!ObjectUtils.isEmpty((Object[])valueProfiles)) {
                profiles = valueProfiles;
            }
            for (Object profile : profiles) {
                if (!StringUtils.hasText((String)profile)) continue;
                activeProfiles.add(((String)profile).trim());
            }
            declaringClass = annotation.inheritProfiles() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
        }
        return StringUtils.toStringArray(activeProfiles);
    }

    static MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, String defaultContextLoaderClassName) {
        String[] activeProfiles;
        Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses;
        Class[] classes;
        String[] locations;
        MergedContextConfiguration mergedConfig;
        List<ContextConfigurationAttributes> configAttributesList = ContextLoaderUtils.resolveContextConfigurationAttributes(testClass);
        ContextLoader contextLoader = ContextLoaderUtils.resolveContextLoader(testClass, configAttributesList, defaultContextLoaderClassName);
        ArrayList<String> locationsList = new ArrayList<String>();
        ArrayList classesList = new ArrayList();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing locations and classes for context configuration attributes %s", configAttributes));
            }
            if (contextLoader instanceof SmartContextLoader) {
                SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
                smartContextLoader.processContextConfiguration(configAttributes);
                locationsList.addAll(0, Arrays.asList(configAttributes.getLocations()));
                classesList.addAll(0, Arrays.asList(configAttributes.getClasses()));
            } else {
                String[] processedLocations = contextLoader.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
                locationsList.addAll(0, Arrays.asList(processedLocations));
            }
            if (configAttributes.isInheritLocations()) continue;
            break;
        }
        if ((mergedConfig = ContextLoaderUtils.buildWebMergedContextConfiguration(testClass, locations = StringUtils.toStringArray(locationsList), classes = ClassUtils.toClassArray(classesList), initializerClasses = ContextLoaderUtils.resolveInitializerClasses(configAttributesList), activeProfiles = ContextLoaderUtils.resolveActiveProfiles(testClass), contextLoader)) == null) {
            mergedConfig = new MergedContextConfiguration(testClass, locations, classes, initializerClasses, activeProfiles, contextLoader);
        }
        return mergedConfig;
    }

    private static Class<? extends Annotation> loadWebAppConfigurationClass() {
        Class webAppConfigClass;
        block2: {
            webAppConfigClass = null;
            try {
                webAppConfigClass = ClassUtils.forName((String)WEB_APP_CONFIGURATION_CLASS_NAME, (ClassLoader)ContextLoaderUtils.class.getClassLoader());
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Could not load @WebAppConfiguration class [org.springframework.test.context.web.WebAppConfiguration].", t);
            }
        }
        return webAppConfigClass;
    }

    private static MergedContextConfiguration buildWebMergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses, String[] activeProfiles, ContextLoader contextLoader) {
        block4: {
            Class<? extends Annotation> webAppConfigClass = ContextLoaderUtils.loadWebAppConfigurationClass();
            if (webAppConfigClass != null && testClass.isAnnotationPresent(webAppConfigClass)) {
                Annotation annotation = testClass.getAnnotation(webAppConfigClass);
                String resourceBasePath = (String)AnnotationUtils.getValue((Annotation)annotation);
                try {
                    Class webMergedConfigClass = ClassUtils.forName((String)WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME, (ClassLoader)ContextLoaderUtils.class.getClassLoader());
                    Constructor constructor = ClassUtils.getConstructorIfAvailable((Class)webMergedConfigClass, (Class[])new Class[]{Class.class, String[].class, Class[].class, Set.class, String[].class, String.class, ContextLoader.class});
                    if (constructor != null) {
                        return (MergedContextConfiguration)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{testClass, locations, classes, initializerClasses, activeProfiles, resourceBasePath, contextLoader});
                    }
                }
                catch (Throwable t) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Could not instantiate [org.springframework.test.context.web.WebMergedContextConfiguration].", t);
                }
            }
        }
        return null;
    }
}

