/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;

public class ServletTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(ServletTestExecutionListener.class);

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.setUpRequestContextIfNecessary(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.setUpRequestContextIfNecessary(testContext);
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Resetting RequestContextHolder for test context %s.", new Object[]{testContext}));
        }
        RequestContextHolder.resetRequestAttributes();
    }

    private void setUpRequestContextIfNecessary(TestContext testContext) {
        ApplicationContext context = testContext.getApplicationContext();
        if (context instanceof WebApplicationContext) {
            WebApplicationContext wac = (WebApplicationContext)context;
            ServletContext servletContext = wac.getServletContext();
            if (!(servletContext instanceof MockServletContext)) {
                throw new IllegalStateException(String.format("The WebApplicationContext for test context %s must be configured with a MockServletContext.", new Object[]{testContext}));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Setting up MockHttpServletRequest, MockHttpServletResponse, ServletWebRequest, and RequestContextHolder for test context %s.", new Object[]{testContext}));
            }
            if (RequestContextHolder.getRequestAttributes() == null) {
                MockServletContext mockServletContext = (MockServletContext)servletContext;
                MockHttpServletRequest request = new MockHttpServletRequest(mockServletContext);
                MockHttpServletResponse response = new MockHttpServletResponse();
                ServletWebRequest servletWebRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)response);
                RequestContextHolder.setRequestAttributes((RequestAttributes)servletWebRequest);
                if (wac instanceof ConfigurableApplicationContext) {
                    ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)wac;
                    ConfigurableListableBeanFactory bf = configurableApplicationContext.getBeanFactory();
                    bf.registerResolvableDependency(MockHttpServletResponse.class, (Object)response);
                    bf.registerResolvableDependency(ServletWebRequest.class, (Object)servletWebRequest);
                }
            }
        }
    }
}

