/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class JsonPathResultMatchers {
    private JsonPathExpectationsHelper jsonPathHelper;

    protected JsonPathResultMatchers(String expression, Object ... args) {
        this.jsonPathHelper = new JsonPathExpectationsHelper(expression, args);
    }

    public <T> ResultMatcher value(final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                JsonPathResultMatchers.this.jsonPathHelper.assertValue(content, matcher);
            }
        };
    }

    public ResultMatcher value(final Object expectedValue) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                JsonPathResultMatchers.this.jsonPathHelper.assertValue(result.getResponse().getContentAsString(), expectedValue);
            }
        };
    }

    public ResultMatcher exists() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                JsonPathResultMatchers.this.jsonPathHelper.exists(content);
            }
        };
    }

    public ResultMatcher doesNotExist() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                JsonPathResultMatchers.this.jsonPathHelper.doesNotExist(content);
            }
        };
    }

    public ResultMatcher isArray() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                JsonPathResultMatchers.this.jsonPathHelper.assertValueIsArray(content);
            }
        };
    }
}

