/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.jdbc;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.jdbc.SqlConfig;
import org.springframework.util.Assert;

class MergedSqlConfig {
    private final String dataSource;
    private final String transactionManager;
    private final SqlConfig.TransactionMode transactionMode;
    private final String encoding;
    private final String separator;
    private final String commentPrefix;
    private final String blockCommentStartDelimiter;
    private final String blockCommentEndDelimiter;
    private final SqlConfig.ErrorMode errorMode;

    private static <E extends Enum<?>> E getEnum(AnnotationAttributes attributes, String attributeName, E inheritedOrDefaultValue, E defaultValue) {
        Enum value = attributes.getEnum(attributeName);
        if (value == inheritedOrDefaultValue) {
            value = defaultValue;
        }
        return (E)value;
    }

    private static String getString(AnnotationAttributes attributes, String attributeName, String defaultValue) {
        String value = attributes.getString(attributeName);
        if ("".equals(value)) {
            value = defaultValue;
        }
        return value;
    }

    MergedSqlConfig(SqlConfig localSqlConfig, Class<?> testClass) {
        Assert.notNull((Object)localSqlConfig, (String)"Local @SqlConfig must not be null");
        Assert.notNull(testClass, (String)"testClass must not be null");
        AnnotationAttributes attributes = AnnotatedElementUtils.findAnnotationAttributes(testClass, (String)SqlConfig.class.getName());
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                Object value = AnnotationUtils.getValue((Annotation)localSqlConfig, (String)key);
                if (value == null || value.equals("") || value == SqlConfig.TransactionMode.DEFAULT || value == SqlConfig.ErrorMode.DEFAULT) continue;
                attributes.put((Object)key, value);
            }
        } else {
            attributes = AnnotationUtils.getAnnotationAttributes((Annotation)localSqlConfig, (boolean)false, (boolean)false);
        }
        this.dataSource = attributes.getString("dataSource");
        this.transactionManager = attributes.getString("transactionManager");
        this.transactionMode = MergedSqlConfig.getEnum(attributes, "transactionMode", SqlConfig.TransactionMode.DEFAULT, SqlConfig.TransactionMode.INFERRED);
        this.encoding = attributes.getString("encoding");
        this.separator = MergedSqlConfig.getString(attributes, "separator", ";");
        this.commentPrefix = MergedSqlConfig.getString(attributes, "commentPrefix", "--");
        this.blockCommentStartDelimiter = MergedSqlConfig.getString(attributes, "blockCommentStartDelimiter", "/*");
        this.blockCommentEndDelimiter = MergedSqlConfig.getString(attributes, "blockCommentEndDelimiter", "*/");
        this.errorMode = MergedSqlConfig.getEnum(attributes, "errorMode", SqlConfig.ErrorMode.DEFAULT, SqlConfig.ErrorMode.FAIL_ON_ERROR);
    }

    String getDataSource() {
        return this.dataSource;
    }

    String getTransactionManager() {
        return this.transactionManager;
    }

    SqlConfig.TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    String getEncoding() {
        return this.encoding;
    }

    String getSeparator() {
        return this.separator;
    }

    String getCommentPrefix() {
        return this.commentPrefix;
    }

    String getBlockCommentStartDelimiter() {
        return this.blockCommentStartDelimiter;
    }

    String getBlockCommentEndDelimiter() {
        return this.blockCommentEndDelimiter;
    }

    SqlConfig.ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("dataSource", (Object)this.dataSource).append("transactionManager", (Object)this.transactionManager).append("transactionMode", (Object)this.transactionMode).append("encoding", (Object)this.encoding).append("separator", (Object)this.separator).append("commentPrefix", (Object)this.commentPrefix).append("blockCommentStartDelimiter", (Object)this.blockCommentStartDelimiter).append("blockCommentEndDelimiter", (Object)this.blockCommentEndDelimiter).append("errorMode", (Object)this.errorMode).toString();
    }
}

