/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TestContextTransactionUtils;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.test.context.transaction.TransactionConfigurationAttributes;
import org.springframework.test.context.transaction.TransactionContext;
import org.springframework.test.context.transaction.TransactionContextHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TransactionalTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(TransactionalTestExecutionListener.class);
    private static final String DEFAULT_TRANSACTION_MANAGER_NAME = (String)AnnotationUtils.getDefaultValue(TransactionConfiguration.class, (String)"transactionManager");
    private static final Boolean DEFAULT_DEFAULT_ROLLBACK = (Boolean)AnnotationUtils.getDefaultValue(TransactionConfiguration.class, (String)"defaultRollback");
    protected final TransactionAttributeSource attributeSource = new AnnotationTransactionAttributeSource();
    private TransactionConfigurationAttributes configurationAttributes;

    @Override
    public final int getOrder() {
        return 4000;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        TransactionContext txContext = TransactionContextHolder.removeCurrentTransactionContext();
        if (txContext != null) {
            throw new IllegalStateException("Cannot start a new transaction without ending the existing transaction.");
        }
        PlatformTransactionManager tm = null;
        TransactionAttribute transactionAttribute = this.attributeSource.getTransactionAttribute(testMethod, testClass);
        if (transactionAttribute != null) {
            transactionAttribute = TestContextTransactionUtils.createDelegatingTransactionAttribute(testContext, transactionAttribute);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Explicit transaction definition [" + transactionAttribute + "] found for test context " + testContext));
            }
            if (transactionAttribute.getPropagationBehavior() == 4) {
                return;
            }
            tm = this.getTransactionManager(testContext, transactionAttribute.getQualifier());
        }
        if (tm != null) {
            txContext = new TransactionContext(testContext, tm, (TransactionDefinition)transactionAttribute, this.isRollback(testContext));
            this.runBeforeTransactionMethods(testContext);
            txContext.startTransaction();
            TransactionContextHolder.setCurrentTransactionContext(txContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        TransactionContext txContext = TransactionContextHolder.removeCurrentTransactionContext();
        if (txContext != null) {
            TransactionStatus transactionStatus = txContext.getTransactionStatus();
            try {
                if (transactionStatus != null && !transactionStatus.isCompleted()) {
                    txContext.endTransaction();
                }
            }
            finally {
                this.runAfterTransactionMethods(testContext);
            }
        }
    }

    protected void runBeforeTransactionMethods(TestContext testContext) throws Exception {
        try {
            List<Method> methods = this.getAnnotatedMethods(testContext.getTestClass(), BeforeTransaction.class);
            Collections.reverse(methods);
            for (Method method : methods) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing @BeforeTransaction method [" + method + "] for test context " + testContext));
                }
                method.invoke(testContext.getTestInstance(), new Object[0]);
            }
        }
        catch (InvocationTargetException ex) {
            logger.error((Object)("Exception encountered while executing @BeforeTransaction methods for test context " + testContext + "."), ex.getTargetException());
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
        }
    }

    protected void runAfterTransactionMethods(TestContext testContext) throws Exception {
        Throwable afterTransactionException = null;
        List<Method> methods = this.getAnnotatedMethods(testContext.getTestClass(), AfterTransaction.class);
        for (Method method : methods) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing @AfterTransaction method [" + method + "] for test context " + testContext));
                }
                method.invoke(testContext.getTestInstance(), new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (afterTransactionException == null) {
                    afterTransactionException = targetException;
                }
                logger.error((Object)("Exception encountered while executing @AfterTransaction method [" + method + "] for test context " + testContext), targetException);
            }
            catch (Exception ex) {
                if (afterTransactionException == null) {
                    afterTransactionException = ex;
                }
                logger.error((Object)("Exception encountered while executing @AfterTransaction method [" + method + "] for test context " + testContext), (Throwable)ex);
            }
        }
        if (afterTransactionException != null) {
            ReflectionUtils.rethrowException(afterTransactionException);
        }
    }

    protected PlatformTransactionManager getTransactionManager(TestContext testContext, String qualifier) {
        if (StringUtils.hasText((String)qualifier)) {
            try {
                AutowireCapableBeanFactory bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
                return (PlatformTransactionManager)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)bf, PlatformTransactionManager.class, (String)qualifier);
            }
            catch (RuntimeException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)String.format("Caught exception while retrieving transaction manager with qualifier '%s' for test context %s", qualifier, testContext), (Throwable)ex);
                }
                throw ex;
            }
        }
        return this.getTransactionManager(testContext);
    }

    protected PlatformTransactionManager getTransactionManager(TestContext testContext) {
        String tmName = this.retrieveConfigurationAttributes(testContext).getTransactionManagerName();
        return TestContextTransactionUtils.retrieveTransactionManager(testContext, tmName);
    }

    protected final boolean isDefaultRollback(TestContext testContext) throws Exception {
        return this.retrieveConfigurationAttributes(testContext).isDefaultRollback();
    }

    protected final boolean isRollback(TestContext testContext) throws Exception {
        boolean rollback = this.isDefaultRollback(testContext);
        Rollback rollbackAnnotation = (Rollback)AnnotationUtils.findAnnotation((Method)testContext.getTestMethod(), Rollback.class);
        if (rollbackAnnotation != null) {
            boolean rollbackOverride = rollbackAnnotation.value();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Method-level @Rollback(%s) overrides default rollback [%s] for test context %s.", rollbackOverride, rollback, testContext));
            }
            rollback = rollbackOverride;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("No method-level @Rollback override: using default rollback [%s] for test context %s.", rollback, testContext));
        }
        return rollback;
    }

    private List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList results = new ArrayList();
        for (Class<?> current = clazz; current != null && Object.class != current; current = current.getSuperclass()) {
            results.add(current);
        }
        return results;
    }

    private List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Class<?> current : this.getSuperClasses(clazz)) {
            for (Method method : current.getDeclaredMethods()) {
                Annotation annotation = AnnotationUtils.getAnnotation((Method)method, annotationType);
                if (annotation == null || this.isShadowed(method, results)) continue;
                results.add(method);
            }
        }
        return results;
    }

    private boolean isShadowed(Method method, List<Method> previousMethods) {
        for (Method each : previousMethods) {
            if (!this.isShadowed(method, each)) continue;
            return true;
        }
        return false;
    }

    private boolean isShadowed(Method current, Method previous) {
        if (!previous.getName().equals(current.getName())) {
            return false;
        }
        if (previous.getParameterTypes().length != current.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < previous.getParameterTypes().length; ++i) {
            if (previous.getParameterTypes()[i].equals(current.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    TransactionConfigurationAttributes retrieveConfigurationAttributes(TestContext testContext) {
        if (this.configurationAttributes == null) {
            boolean defaultRollback;
            String transactionManagerName;
            Class<?> clazz = testContext.getTestClass();
            AnnotationAttributes annAttrs = AnnotatedElementUtils.findAnnotationAttributes(clazz, (String)TransactionConfiguration.class.getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Retrieved @TransactionConfiguration attributes [%s] for test class [%s].", annAttrs, clazz));
            }
            if (annAttrs != null) {
                transactionManagerName = annAttrs.getString("transactionManager");
                defaultRollback = annAttrs.getBoolean("defaultRollback");
            } else {
                transactionManagerName = DEFAULT_TRANSACTION_MANAGER_NAME;
                defaultRollback = DEFAULT_DEFAULT_ROLLBACK;
            }
            TransactionConfigurationAttributes configAttributes = new TransactionConfigurationAttributes(transactionManagerName, defaultRollback);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Retrieved TransactionConfigurationAttributes %s for class [%s].", configAttributes, clazz));
            }
            this.configurationAttributes = configAttributes;
        }
        return this.configurationAttributes;
    }
}

