/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.lang.reflect.Method;
import org.junit.Assume;
import org.junit.runners.model.Statement;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.util.Assert;

public class ProfileValueChecker
extends Statement {
    private final Statement next;
    private final Class<?> testClass;
    private final Method testMethod;

    public ProfileValueChecker(Statement next, Class<?> testClass, Method testMethod) {
        Assert.notNull((Object)next, (String)"The next statement must not be null");
        Assert.notNull(testClass, (String)"The test class must not be null");
        this.next = next;
        this.testClass = testClass;
        this.testMethod = testMethod;
    }

    public void evaluate() throws Throwable {
        if (this.testMethod == null) {
            if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.testClass)) {
                Assume.assumeTrue((String)String.format("Profile configured via [%s] is not enabled in this environment for test class [%s].", AnnotationUtils.findAnnotation(this.testClass, IfProfileValue.class), this.testClass.getName()), (boolean)false);
            }
        } else if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.testMethod, this.testClass)) {
            Assume.assumeTrue((String)String.format("Profile configured via @IfProfileValue is not enabled in this environment for test method [%s].", this.testMethod), (boolean)false);
        }
        this.next.evaluate();
    }
}

