/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

abstract class BootstrapUtils {
    private static final String DEFAULT_BOOTSTRAP_CONTEXT_CLASS_NAME = "org.springframework.test.context.support.DefaultBootstrapContext";
    private static final String DEFAULT_CACHE_AWARE_CONTEXT_LOADER_DELEGATE_CLASS_NAME = "org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate";
    private static final String DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME = "org.springframework.test.context.support.DefaultTestContextBootstrapper";
    private static final Log logger = LogFactory.getLog(BootstrapUtils.class);

    private BootstrapUtils() {
    }

    static BootstrapContext createBootstrapContext(Class<?> testClass) {
        CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate = BootstrapUtils.createCacheAwareContextLoaderDelegate();
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)DEFAULT_BOOTSTRAP_CONTEXT_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
            Constructor constructor = clazz.getConstructor(Class.class, CacheAwareContextLoaderDelegate.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating BootstrapContext using constructor [%s]", constructor));
            }
            return (BootstrapContext)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{testClass, cacheAwareContextLoaderDelegate});
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not load BootstrapContext [" + clazz + "]", t);
        }
    }

    private static CacheAwareContextLoaderDelegate createCacheAwareContextLoaderDelegate() {
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)DEFAULT_CACHE_AWARE_CONTEXT_LOADER_DELEGATE_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating CacheAwareContextLoaderDelegate from class [%s]", clazz.getName()));
            }
            return (CacheAwareContextLoaderDelegate)BeanUtils.instantiateClass((Class)clazz, CacheAwareContextLoaderDelegate.class);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not load CacheAwareContextLoaderDelegate [" + clazz + "]", t);
        }
    }

    static TestContextBootstrapper resolveTestContextBootstrapper(BootstrapContext bootstrapContext) {
        Class<?> testClass = bootstrapContext.getTestClass();
        Class clazz = null;
        try {
            List values;
            MultiValueMap attributesMultiMap = AnnotatedElementUtils.getAllAnnotationAttributes(testClass, (String)BootstrapWith.class.getName());
            List list = values = attributesMultiMap == null ? null : (List)attributesMultiMap.get((Object)"value");
            if (values != null) {
                if (values.size() != 1) {
                    String msg = String.format("Configuration error: found multiple declarations of @BootstrapWith on test class [%s] with values %s", testClass.getName(), values);
                    throw new IllegalStateException(msg);
                }
                clazz = (Class)values.get(0);
            } else {
                clazz = ClassUtils.forName((String)DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating TestContextBootstrapper for test class [%s] from class [%s]", testClass.getName(), clazz.getName()));
            }
            TestContextBootstrapper testContextBootstrapper = (TestContextBootstrapper)BeanUtils.instantiateClass((Class)clazz, TestContextBootstrapper.class);
            testContextBootstrapper.setBootstrapContext(bootstrapContext);
            return testContextBootstrapper;
        }
        catch (Throwable t) {
            if (t instanceof IllegalStateException) {
                throw (IllegalStateException)t;
            }
            throw new IllegalStateException("Could not load TestContextBootstrapper [" + clazz + "]. Specify @BootstrapWith's 'value' attribute " + "or make the default bootstrapper class available.", t);
        }
    }
}

