/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

public class HandlerResultMatchers {
    protected HandlerResultMatchers() {
    }

    public ResultMatcher handlerType(final Class<?> type) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                Object handler = result.getHandler();
                AssertionErrors.assertTrue("No handler: ", handler != null);
                Class actual = handler.getClass();
                if (HandlerMethod.class.isInstance(handler)) {
                    actual = ((HandlerMethod)handler).getBeanType();
                }
                AssertionErrors.assertEquals("Handler type", type, ClassUtils.getUserClass((Class)actual));
            }
        };
    }

    public ResultMatcher methodCall(final Object info) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                HandlerMethod handlerMethod = HandlerResultMatchers.getHandlerMethod(result);
                Method method = ((MvcUriComponentsBuilder.MethodInvocationInfo)info).getControllerMethod();
                AssertionErrors.assertEquals("HandlerMethod", method, handlerMethod.getMethod());
            }
        };
    }

    public ResultMatcher methodName(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                HandlerMethod handlerMethod = HandlerResultMatchers.getHandlerMethod(result);
                MatcherAssert.assertThat((String)"HandlerMethod", (Object)handlerMethod.getMethod().getName(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher methodName(final String name) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                HandlerMethod handlerMethod = HandlerResultMatchers.getHandlerMethod(result);
                AssertionErrors.assertEquals("HandlerMethod", name, handlerMethod.getMethod().getName());
            }
        };
    }

    public ResultMatcher method(final Method method) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                HandlerMethod handlerMethod = HandlerResultMatchers.getHandlerMethod(result);
                AssertionErrors.assertEquals("HandlerMethod", method, handlerMethod.getMethod());
            }
        };
    }

    private static HandlerMethod getHandlerMethod(MvcResult result) {
        Object handler = result.getHandler();
        AssertionErrors.assertTrue("No handler: ", handler != null);
        AssertionErrors.assertTrue("Not a HandlerMethod: " + handler, HandlerMethod.class.isInstance(handler));
        return (HandlerMethod)handler;
    }
}

