/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.server.reactive;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public class MockServerHttpRequest
implements ServerHttpRequest {
    private HttpMethod httpMethod;
    private URI url;
    private final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap();
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();
    private Flux<DataBuffer> body = Flux.empty();

    public MockServerHttpRequest() {
    }

    public MockServerHttpRequest(HttpMethod httpMethod, String url) {
        this(httpMethod, url != null ? URI.create(url) : null);
    }

    public MockServerHttpRequest(HttpMethod httpMethod, URI url) {
        this.httpMethod = httpMethod;
        this.url = url;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public MockServerHttpRequest setUri(String url) {
        this.url = URI.create(url);
        return this;
    }

    public MockServerHttpRequest setUri(URI uri) {
        this.url = uri;
        return this;
    }

    public URI getURI() {
        return this.url;
    }

    public MockServerHttpRequest addHeader(String name, String value) {
        this.getHeaders().add(name, value);
        return this;
    }

    public MockServerHttpRequest setHeader(String name, String value) {
        this.getHeaders().set(name, value);
        return this;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public MultiValueMap<String, HttpCookie> getCookies() {
        return this.cookies;
    }

    public MockServerHttpRequest setBody(Publisher<DataBuffer> body) {
        this.body = Flux.from(body);
        return this;
    }

    public MockServerHttpRequest setBody(String body) {
        DataBuffer buffer = this.toDataBuffer(body, StandardCharsets.UTF_8);
        this.body = Flux.just((Object)buffer);
        return this;
    }

    public MockServerHttpRequest setBody(String body, Charset charset) {
        DataBuffer buffer = this.toDataBuffer(body, charset);
        this.body = Flux.just((Object)buffer);
        return this;
    }

    private DataBuffer toDataBuffer(String body, Charset charset) {
        byte[] bytes = body.getBytes(charset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return new DefaultDataBufferFactory().wrap(byteBuffer);
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }
}

