/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.server.reactive;

import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockServerHttpResponse
implements ServerHttpResponse {
    private HttpStatus status;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap();
    private Publisher<DataBuffer> body;
    private Publisher<Publisher<DataBuffer>> bodyWithFlushes;
    private DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public boolean setStatusCode(HttpStatus status) {
        this.status = status;
        return true;
    }

    public HttpStatus getStatusCode() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    public Publisher<DataBuffer> getBody() {
        return this.body;
    }

    public Publisher<Publisher<DataBuffer>> getBodyWithFlush() {
        return this.bodyWithFlushes;
    }

    public Mono<Void> writeWith(Publisher<DataBuffer> body) {
        this.body = body;
        return Flux.from(this.body).then();
    }

    public Mono<Void> writeAndFlushWith(Publisher<Publisher<DataBuffer>> body) {
        this.bodyWithFlushes = body;
        return Flux.from(this.bodyWithFlushes).then();
    }

    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
    }

    public Mono<Void> setComplete() {
        return Mono.empty();
    }

    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }
}

