/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.web.servlet.setup.AbstractMockMvcBuilder;
import org.springframework.test.web.servlet.setup.StubWebApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringValueResolver;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.view.DefaultRequestToViewNameTranslator;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

public class StandaloneMockMvcBuilder
extends AbstractMockMvcBuilder<StandaloneMockMvcBuilder> {
    private final Object[] controllers;
    private List<Object> controllerAdvice;
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private List<HandlerMethodReturnValueHandler> customReturnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
    private final List<MappedInterceptor> mappedInterceptors = new ArrayList<MappedInterceptor>();
    private Validator validator = null;
    private ContentNegotiationManager contentNegotiationManager;
    private FormattingConversionService conversionService = null;
    private List<HandlerExceptionResolver> handlerExceptionResolvers;
    private Long asyncRequestTimeout;
    private List<ViewResolver> viewResolvers;
    private LocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
    private FlashMapManager flashMapManager = null;
    private boolean useSuffixPatternMatch = true;
    private boolean useTrailingSlashPatternMatch = true;
    private Boolean removeSemicolonContent;
    private Map<String, String> placeholderValues = new HashMap<String, String>();

    protected StandaloneMockMvcBuilder(Object ... controllers) {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])controllers) ? 1 : 0) != 0, (String)"At least one controller is required");
        this.controllers = controllers;
    }

    public StandaloneMockMvcBuilder setControllerAdvice(Object ... controllerAdvice) {
        this.controllerAdvice = Arrays.asList(controllerAdvice);
        return this;
    }

    public StandaloneMockMvcBuilder setMessageConverters(HttpMessageConverter<?> ... messageConverters) {
        this.messageConverters = Arrays.asList(messageConverters);
        return this;
    }

    public StandaloneMockMvcBuilder setValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public StandaloneMockMvcBuilder setConversionService(FormattingConversionService conversionService) {
        this.conversionService = conversionService;
        return this;
    }

    public StandaloneMockMvcBuilder addInterceptors(HandlerInterceptor ... interceptors) {
        this.addMappedInterceptors(null, interceptors);
        return this;
    }

    public StandaloneMockMvcBuilder addMappedInterceptors(String[] pathPatterns, HandlerInterceptor ... interceptors) {
        for (HandlerInterceptor interceptor : interceptors) {
            this.mappedInterceptors.add(new MappedInterceptor(pathPatterns, interceptor));
        }
        return this;
    }

    protected StandaloneMockMvcBuilder setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
        return this;
    }

    public StandaloneMockMvcBuilder setAsyncRequestTimeout(long timeout) {
        this.asyncRequestTimeout = timeout;
        return this;
    }

    public StandaloneMockMvcBuilder setCustomArgumentResolvers(HandlerMethodArgumentResolver ... argumentResolvers) {
        this.customArgumentResolvers = Arrays.asList(argumentResolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setCustomReturnValueHandlers(HandlerMethodReturnValueHandler ... handlers) {
        this.customReturnValueHandlers = Arrays.asList(handlers);
        return this;
    }

    public StandaloneMockMvcBuilder setHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        this.handlerExceptionResolvers = exceptionResolvers;
        return this;
    }

    public StandaloneMockMvcBuilder setHandlerExceptionResolvers(HandlerExceptionResolver ... exceptionResolvers) {
        this.handlerExceptionResolvers = Arrays.asList(exceptionResolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setViewResolvers(ViewResolver ... resolvers) {
        this.viewResolvers = Arrays.asList(resolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setSingleView(View view) {
        this.viewResolvers = Collections.singletonList(new StaticViewResolver(view));
        return this;
    }

    public StandaloneMockMvcBuilder setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
        return this;
    }

    public StandaloneMockMvcBuilder setFlashMapManager(FlashMapManager flashMapManager) {
        this.flashMapManager = flashMapManager;
        return this;
    }

    public StandaloneMockMvcBuilder setUseSuffixPatternMatch(boolean useSuffixPatternMatch) {
        this.useSuffixPatternMatch = useSuffixPatternMatch;
        return this;
    }

    public StandaloneMockMvcBuilder setUseTrailingSlashPatternMatch(boolean useTrailingSlashPatternMatch) {
        this.useTrailingSlashPatternMatch = useTrailingSlashPatternMatch;
        return this;
    }

    public StandaloneMockMvcBuilder setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.removeSemicolonContent = removeSemicolonContent;
        return this;
    }

    public StandaloneMockMvcBuilder addPlaceholderValue(String name, String value) {
        this.placeholderValues.put(name, value);
        return this;
    }

    @Override
    protected WebApplicationContext initWebAppContext() {
        MockServletContext servletContext = new MockServletContext();
        StubWebApplicationContext wac = new StubWebApplicationContext(servletContext);
        this.registerMvcSingletons(wac);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, wac);
        return wac;
    }

    private void registerMvcSingletons(StubWebApplicationContext wac) {
        StandaloneConfiguration config = new StandaloneConfiguration();
        config.setApplicationContext((ApplicationContext)wac);
        wac.addBeans(this.controllerAdvice);
        StaticRequestMappingHandlerMapping hm = config.getHandlerMapping();
        hm.setServletContext(wac.getServletContext());
        hm.setApplicationContext((ApplicationContext)wac);
        hm.afterPropertiesSet();
        hm.registerHandlers(this.controllers);
        wac.addBean("requestMappingHandlerMapping", (Object)hm);
        RequestMappingHandlerAdapter handlerAdapter = config.requestMappingHandlerAdapter();
        handlerAdapter.setServletContext(wac.getServletContext());
        handlerAdapter.setApplicationContext((ApplicationContext)wac);
        handlerAdapter.afterPropertiesSet();
        wac.addBean("requestMappingHandlerAdapter", handlerAdapter);
        wac.addBean("handlerExceptionResolver", config.handlerExceptionResolver());
        wac.addBeans(this.initViewResolvers(wac));
        wac.addBean("localeResolver", this.localeResolver);
        wac.addBean("themeResolver", new FixedThemeResolver());
        wac.addBean("viewNameTranslator", new DefaultRequestToViewNameTranslator());
        this.flashMapManager = new SessionFlashMapManager();
        wac.addBean("flashMapManager", this.flashMapManager);
    }

    private List<ViewResolver> initViewResolvers(WebApplicationContext wac) {
        this.viewResolvers = this.viewResolvers != null ? this.viewResolvers : Collections.singletonList(new InternalResourceViewResolver());
        for (ViewResolver viewResolver : this.viewResolvers) {
            if (!(viewResolver instanceof WebApplicationObjectSupport)) continue;
            ((WebApplicationObjectSupport)viewResolver).setApplicationContext((ApplicationContext)wac);
        }
        return this.viewResolvers;
    }

    private static class StaticViewResolver
    implements ViewResolver {
        private final View view;

        public StaticViewResolver(View view) {
            this.view = view;
        }

        public View resolveViewName(String viewName, Locale locale) throws Exception {
            return this.view;
        }
    }

    private static class StaticStringValueResolver
    implements StringValueResolver {
        private final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", false);
        private final PropertyPlaceholderHelper.PlaceholderResolver resolver;

        public StaticStringValueResolver(final Map<String, String> values) {
            this.resolver = new PropertyPlaceholderHelper.PlaceholderResolver(){

                public String resolvePlaceholder(String placeholderName) {
                    return (String)values.get(placeholderName);
                }
            };
        }

        public String resolveStringValue(String strVal) throws BeansException {
            return this.helper.replacePlaceholders(strVal, this.resolver);
        }
    }

    private static class StaticRequestMappingHandlerMapping
    extends RequestMappingHandlerMapping {
        private StaticRequestMappingHandlerMapping() {
        }

        public void registerHandlers(Object ... handlers) {
            for (Object handler : handlers) {
                this.detectHandlerMethods(handler);
            }
        }
    }

    private class StandaloneConfiguration
    extends WebMvcConfigurationSupport {
        private StandaloneConfiguration() {
        }

        public StaticRequestMappingHandlerMapping getHandlerMapping() {
            StaticRequestMappingHandlerMapping handlerMapping = new StaticRequestMappingHandlerMapping();
            handlerMapping.setEmbeddedValueResolver(new StaticStringValueResolver(StandaloneMockMvcBuilder.this.placeholderValues));
            handlerMapping.setUseSuffixPatternMatch(StandaloneMockMvcBuilder.this.useSuffixPatternMatch);
            handlerMapping.setUseTrailingSlashMatch(StandaloneMockMvcBuilder.this.useTrailingSlashPatternMatch);
            handlerMapping.setOrder(0);
            handlerMapping.setInterceptors(this.getInterceptors());
            if (StandaloneMockMvcBuilder.this.removeSemicolonContent != null) {
                handlerMapping.setRemoveSemicolonContent(StandaloneMockMvcBuilder.this.removeSemicolonContent);
            }
            return handlerMapping;
        }

        protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.addAll(StandaloneMockMvcBuilder.this.messageConverters);
        }

        protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.addAll(StandaloneMockMvcBuilder.this.customArgumentResolvers);
        }

        protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
            returnValueHandlers.addAll(StandaloneMockMvcBuilder.this.customReturnValueHandlers);
        }

        protected void addInterceptors(InterceptorRegistry registry) {
            for (MappedInterceptor interceptor : StandaloneMockMvcBuilder.this.mappedInterceptors) {
                InterceptorRegistration registration = registry.addInterceptor(interceptor.getInterceptor());
                if (interceptor.getPathPatterns() == null) continue;
                registration.addPathPatterns(interceptor.getPathPatterns());
            }
        }

        public ContentNegotiationManager mvcContentNegotiationManager() {
            return StandaloneMockMvcBuilder.this.contentNegotiationManager != null ? StandaloneMockMvcBuilder.this.contentNegotiationManager : super.mvcContentNegotiationManager();
        }

        public FormattingConversionService mvcConversionService() {
            return StandaloneMockMvcBuilder.this.conversionService != null ? StandaloneMockMvcBuilder.this.conversionService : super.mvcConversionService();
        }

        public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
            if (StandaloneMockMvcBuilder.this.asyncRequestTimeout != null) {
                configurer.setDefaultTimeout(StandaloneMockMvcBuilder.this.asyncRequestTimeout.longValue());
            }
        }

        public Validator mvcValidator() {
            Validator mvcValidator;
            Validator validator = mvcValidator = StandaloneMockMvcBuilder.this.validator != null ? StandaloneMockMvcBuilder.this.validator : super.mvcValidator();
            if (mvcValidator instanceof InitializingBean) {
                try {
                    ((InitializingBean)mvcValidator).afterPropertiesSet();
                }
                catch (Exception ex) {
                    throw new BeanInitializationException("Failed to initialize Validator", (Throwable)ex);
                }
            }
            return mvcValidator;
        }

        protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
            if (StandaloneMockMvcBuilder.this.handlerExceptionResolvers == null) {
                return;
            }
            for (HandlerExceptionResolver resolver : StandaloneMockMvcBuilder.this.handlerExceptionResolvers) {
                if (resolver instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)resolver).setApplicationContext(this.getApplicationContext());
                }
                if (resolver instanceof InitializingBean) {
                    try {
                        ((InitializingBean)resolver).afterPropertiesSet();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Failure from afterPropertiesSet", ex);
                    }
                }
                exceptionResolvers.add(resolver);
            }
        }
    }
}

