/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.test.web.reactive.server.DefaultControllerSpec;
import org.springframework.test.web.reactive.server.DefaultWebTestClientBuilder;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.FluxExchangeResult;
import org.springframework.test.web.reactive.server.HeaderAssertions;
import org.springframework.test.web.reactive.server.StatusAssertions;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.Validator;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.config.PathMatchConfigurer;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;

public interface WebTestClient {
    public UriSpec get();

    public UriSpec head();

    public UriSpec post();

    public UriSpec put();

    public UriSpec patch();

    public UriSpec delete();

    public UriSpec options();

    public WebTestClient filter(ExchangeFilterFunction var1);

    public static ControllerSpec bindToController(Object ... controllers) {
        return new DefaultControllerSpec(controllers);
    }

    public static Builder bindToApplicationContext(ApplicationContext applicationContext) {
        HttpHandler httpHandler = WebHttpHandlerBuilder.applicationContext((ApplicationContext)applicationContext).build();
        return new DefaultWebTestClientBuilder(httpHandler);
    }

    public static Builder bindToRouterFunction(RouterFunction<?> routerFunction) {
        HttpWebHandlerAdapter httpHandler = RouterFunctions.toHttpHandler(routerFunction);
        return new DefaultWebTestClientBuilder((HttpHandler)httpHandler);
    }

    public static Builder bindToServer() {
        return new DefaultWebTestClientBuilder();
    }

    public static interface MapBodySpec {
        public <K, V> EntityExchangeResult<Map<K, V>> isEqualTo(Map<K, V> var1);

        public MapBodySpec hasSize(int var1);

        public MapBodySpec contains(Object var1, Object var2);

        public MapBodySpec containsKeys(Object ... var1);

        public MapBodySpec containsValues(Object ... var1);

        public <K, V> EntityExchangeResult<Map<K, V>> returnResult();
    }

    public static interface BodySpec {
        public EntityExchangeResult<Void> isEmpty();

        public MapBodySpec map(Class<?> var1, Class<?> var2);

        public MapBodySpec map(ResolvableType var1, ResolvableType var2);
    }

    public static interface ListBodySpec {
        public <T> EntityExchangeResult<List<T>> isEqualTo(List<T> var1);

        public ListBodySpec hasSize(int var1);

        public ListBodySpec contains(Object ... var1);

        public ListBodySpec doesNotContain(Object ... var1);

        public <T> EntityExchangeResult<List<T>> returnResult();
    }

    public static interface SingleValueBodySpec {
        public <T> EntityExchangeResult<T> isEqualTo(T var1);

        public <T> EntityExchangeResult<T> returnResult();
    }

    public static interface TypeBodySpec {
        public SingleValueBodySpec value();

        public ListBodySpec list();

        public ListBodySpec list(int var1);

        public <T> FluxExchangeResult<T> returnResult();
    }

    public static interface ResponseSpec {
        public StatusAssertions expectStatus();

        public HeaderAssertions expectHeader();

        public TypeBodySpec expectBody(Class<?> var1);

        public TypeBodySpec expectBody(ResolvableType var1);

        public BodySpec expectBody();

        public ResponseSpec consumeWith(Consumer<ExchangeResult> var1);

        public ExchangeResult returnResult();
    }

    public static interface HeaderSpec {
        public HeaderSpec accept(MediaType ... var1);

        public HeaderSpec acceptCharset(Charset ... var1);

        public HeaderSpec contentLength(long var1);

        public HeaderSpec contentType(MediaType var1);

        public HeaderSpec cookie(String var1, String var2);

        public HeaderSpec cookies(MultiValueMap<String, String> var1);

        public HeaderSpec ifModifiedSince(ZonedDateTime var1);

        public HeaderSpec ifNoneMatch(String ... var1);

        public HeaderSpec header(String var1, String ... var2);

        public HeaderSpec headers(HttpHeaders var1);

        public ResponseSpec exchange();

        public <T> ResponseSpec exchange(BodyInserter<T, ? super ClientHttpRequest> var1);

        public <T, S extends Publisher<T>> ResponseSpec exchange(S var1, Class<T> var2);
    }

    public static interface UriSpec {
        public HeaderSpec uri(URI var1);

        public HeaderSpec uri(String var1, Object ... var2);

        public HeaderSpec uri(String var1, Map<String, ?> var2);

        public HeaderSpec uri(Function<UriBuilder, URI> var1);
    }

    public static interface Builder {
        public Builder baseUrl(String var1);

        public Builder uriBuilderFactory(UriBuilderFactory var1);

        public Builder defaultHeader(String var1, String ... var2);

        public Builder defaultCookie(String var1, String ... var2);

        public Builder exchangeStrategies(ExchangeStrategies var1);

        public Builder responseTimeout(Duration var1);

        public WebTestClient build();
    }

    public static interface ControllerSpec {
        public ControllerSpec contentTypeResolver(Consumer<RequestedContentTypeResolverBuilder> var1);

        public ControllerSpec corsMappings(Consumer<CorsRegistry> var1);

        public ControllerSpec pathMatching(Consumer<PathMatchConfigurer> var1);

        public ControllerSpec messageReaders(Consumer<List<HttpMessageReader<?>>> var1);

        public ControllerSpec messageWriters(Consumer<List<HttpMessageWriter<?>>> var1);

        public ControllerSpec formatters(Consumer<FormatterRegistry> var1);

        public ControllerSpec validator(Validator var1);

        public ControllerSpec viewResolvers(Consumer<ViewResolverRegistry> var1);

        public Builder configureClient();

        public WebTestClient build();
    }
}

