/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractExpressionEvaluatingCondition
implements ExecutionCondition {
    private static final Log logger = LogFactory.getLog(AbstractExpressionEvaluatingCondition.class);

    AbstractExpressionEvaluatingCondition() {
    }

    protected <A extends Annotation> ConditionEvaluationResult evaluateAnnotation(Class<A> annotationType, Function<A, String> expressionExtractor, Function<A, String> reasonExtractor, Function<A, Boolean> loadContextExtractor, boolean enabledOnTrue, ExtensionContext context) {
        boolean loadContext;
        AnnotatedElement element = (AnnotatedElement)context.getElement().get();
        Optional<A> annotation = AbstractExpressionEvaluatingCondition.findMergedAnnotation(element, annotationType);
        if (!annotation.isPresent()) {
            String reason = String.format("%s is enabled since @%s is not present", element, annotationType.getSimpleName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)reason);
            }
            return ConditionEvaluationResult.enabled((String)reason);
        }
        String expression = annotation.map(expressionExtractor).map(String::trim).filter(StringUtils::hasLength).orElseThrow(() -> new IllegalStateException(String.format("The expression in @%s on [%s] must not be blank", annotationType.getSimpleName(), element)));
        boolean evaluatedToTrue = this.evaluateExpression(expression, loadContext = annotation.map(loadContextExtractor).get().booleanValue(), annotationType, context);
        if (evaluatedToTrue) {
            String adjective = enabledOnTrue ? "enabled" : "disabled";
            String reason = annotation.map(reasonExtractor).filter(StringUtils::hasText).orElseGet(() -> String.format("%s is %s because @%s(\"%s\") evaluated to true", element, adjective, annotationType.getSimpleName(), expression));
            if (logger.isInfoEnabled()) {
                logger.info((Object)reason);
            }
            return enabledOnTrue ? ConditionEvaluationResult.enabled((String)reason) : ConditionEvaluationResult.disabled((String)reason);
        }
        String adjective = enabledOnTrue ? "disabled" : "enabled";
        String reason = String.format("%s is %s because @%s(\"%s\") did not evaluate to true", element, adjective, annotationType.getSimpleName(), expression);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)reason);
        }
        return enabledOnTrue ? ConditionEvaluationResult.disabled((String)reason) : ConditionEvaluationResult.enabled((String)reason);
    }

    private <A extends Annotation> boolean evaluateExpression(String expression, boolean loadContext, Class<A> annotationType, ExtensionContext extensionContext) {
        ApplicationContext applicationContext;
        AnnotatedElement element = (AnnotatedElement)extensionContext.getElement().get();
        GenericApplicationContext gac = null;
        if (loadContext) {
            applicationContext = SpringExtension.getApplicationContext(extensionContext);
        } else {
            gac = new GenericApplicationContext();
            gac.refresh();
            applicationContext = gac;
        }
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            if (logger.isWarnEnabled()) {
                String contextType = applicationContext.getClass().getName();
                logger.warn((Object)String.format("@%s(\"%s\") could not be evaluated on [%s] since the test ApplicationContext [%s] is not a ConfigurableApplicationContext", annotationType.getSimpleName(), expression, element, contextType));
            }
            return false;
        }
        ConfigurableListableBeanFactory configurableBeanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        BeanExpressionResolver expressionResolver = configurableBeanFactory.getBeanExpressionResolver();
        Assert.state((expressionResolver != null ? 1 : 0) != 0, (String)"No BeanExpressionResolver");
        BeanExpressionContext beanExpressionContext = new BeanExpressionContext((ConfigurableBeanFactory)configurableBeanFactory, null);
        Object result = expressionResolver.evaluate(configurableBeanFactory.resolveEmbeddedValue(expression), beanExpressionContext);
        if (gac != null) {
            gac.close();
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            String str = ((String)result).trim().toLowerCase();
            if ("true".equals(str)) {
                return true;
            }
            Assert.state((boolean)"false".equals(str), () -> String.format("@%s(\"%s\") on %s must evaluate to \"true\" or \"false\", not \"%s\"", annotationType.getSimpleName(), expression, element, result));
            return false;
        }
        String message = String.format("@%s(\"%s\") on %s must evaluate to a String or a Boolean, not %s", annotationType.getSimpleName(), expression, element, result != null ? result.getClass().getName() : "null");
        throw new IllegalStateException(message);
    }

    private static <A extends Annotation> Optional<A> findMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, annotationType));
    }
}

