/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.util.Assert;

public class DefaultTestContext
implements TestContext {
    private static final long serialVersionUID = -5827157174866681233L;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>(4);
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;
    private final MergedContextConfiguration mergedContextConfiguration;
    private final Class<?> testClass;
    @Nullable
    private volatile Object testInstance;
    @Nullable
    private volatile Method testMethod;
    @Nullable
    private volatile Throwable testException;

    public DefaultTestContext(DefaultTestContext testContext) {
        this(testContext.testClass, testContext.mergedContextConfiguration, testContext.cacheAwareContextLoaderDelegate);
        this.attributes.putAll(testContext.attributes);
    }

    public DefaultTestContext(Class<?> testClass, MergedContextConfiguration mergedContextConfiguration, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        Assert.notNull(testClass, (String)"Test Class must not be null");
        Assert.notNull((Object)mergedContextConfiguration, (String)"MergedContextConfiguration must not be null");
        Assert.notNull((Object)cacheAwareContextLoaderDelegate, (String)"CacheAwareContextLoaderDelegate must not be null");
        this.testClass = testClass;
        this.mergedContextConfiguration = mergedContextConfiguration;
        this.cacheAwareContextLoaderDelegate = cacheAwareContextLoaderDelegate;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        ApplicationContext context = this.cacheAwareContextLoaderDelegate.loadContext(this.mergedContextConfiguration);
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)context;
            Assert.state((boolean)cac.isActive(), () -> "The ApplicationContext loaded for [" + this.mergedContextConfiguration + "] is not active. This may be due to one of the following reasons: 1) the context was closed programmatically by user code; 2) the context was closed during parallel test execution either according to @DirtiesContext semantics or due to automatic eviction from the ContextCache due to a maximum cache size policy.");
        }
        return context;
    }

    @Override
    public void markApplicationContextDirty(@Nullable DirtiesContext.HierarchyMode hierarchyMode) {
        this.cacheAwareContextLoaderDelegate.closeContext(this.mergedContextConfiguration, hierarchyMode);
    }

    @Override
    public final Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public final Object getTestInstance() {
        Object testInstance = this.testInstance;
        Assert.state((testInstance != null ? 1 : 0) != 0, (String)"No test instance");
        return testInstance;
    }

    @Override
    public final Method getTestMethod() {
        Method testMethod = this.testMethod;
        Assert.state((testMethod != null ? 1 : 0) != 0, (String)"No test method");
        return testMethod;
    }

    @Override
    @Nullable
    public final Throwable getTestException() {
        return this.testException;
    }

    @Override
    public void updateState(@Nullable Object testInstance, @Nullable Method testMethod, @Nullable Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, @Nullable Object value) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
        }
    }

    public Object getAttribute(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return this.attributes.remove(name);
    }

    public boolean hasAttribute(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return this.attributes.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] attributeNames() {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return (String[])this.attributes.keySet().stream().toArray(String[]::new);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.testClass).append("testInstance", this.testInstance).append("testMethod", (Object)this.testMethod).append("testException", (Object)this.testException).append("mergedContextConfiguration", (Object)this.mergedContextConfiguration).append("attributes", this.attributes).toString();
    }
}

