/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.match.ContentRequestMatchers;
import org.springframework.test.web.client.match.JsonPathRequestMatchers;
import org.springframework.test.web.client.match.XpathRequestMatchers;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class MockRestRequestMatchers {
    public static RequestMatcher anything() {
        return request -> {};
    }

    public static RequestMatcher method(HttpMethod method) {
        org.springframework.util.Assert.notNull((Object)method, (String)"'method' must not be null");
        return request -> AssertionErrors.assertEquals("Unexpected HttpMethod", method, request.getMethod());
    }

    public static RequestMatcher requestTo(Matcher<String> matcher) {
        org.springframework.util.Assert.notNull(matcher, (String)"'matcher' must not be null");
        return request -> MatcherAssert.assertThat((String)"Request URI", (Object)request.getURI().toString(), (Matcher)matcher);
    }

    public static RequestMatcher requestTo(String expectedUri) {
        org.springframework.util.Assert.notNull((Object)expectedUri, (String)"'uri' must not be null");
        return request -> AssertionErrors.assertEquals("Request URI", expectedUri, request.getURI().toString());
    }

    public static RequestMatcher requestTo(URI uri) {
        org.springframework.util.Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return request -> AssertionErrors.assertEquals("Unexpected request", uri, request.getURI());
    }

    @SafeVarargs
    public static RequestMatcher queryParam(String name, Matcher<? super String> ... matchers) {
        return request -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request);
            MockRestRequestMatchers.assertValueCount("query param", name, params, matchers.length);
            for (int i = 0; i < matchers.length; ++i) {
                MatcherAssert.assertThat((String)"Query param", ((List)params.get((Object)name)).get(i), (Matcher)matchers[i]);
            }
        };
    }

    public static RequestMatcher queryParam(String name, String ... expectedValues) {
        return request -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request);
            MockRestRequestMatchers.assertValueCount("query param", name, params, expectedValues.length);
            for (int i = 0; i < expectedValues.length; ++i) {
                AssertionErrors.assertEquals("Query param + [" + name + "]", expectedValues[i], ((List)params.get((Object)name)).get(i));
            }
        };
    }

    private static MultiValueMap<String, String> getQueryParams(ClientHttpRequest request) {
        return UriComponentsBuilder.fromUri((URI)request.getURI()).build().getQueryParams();
    }

    private static void assertValueCount(String valueType, String name, MultiValueMap<String, String> map, int count) {
        List values = (List)map.get((Object)name);
        String message = "Expected " + valueType + " <" + name + ">";
        Assert.assertNotNull((String)message, (Object)values);
        AssertionErrors.assertTrue(message + " to have at least <" + count + "> values but found " + values, count <= values.size());
    }

    @SafeVarargs
    public static RequestMatcher header(String name, Matcher<? super String> ... matchers) {
        return request -> {
            MockRestRequestMatchers.assertValueCount("header", name, (MultiValueMap<String, String>)request.getHeaders(), matchers.length);
            List headerValues = request.getHeaders().get((Object)name);
            org.springframework.util.Assert.state((headerValues != null ? 1 : 0) != 0, (String)"No header values");
            for (int i = 0; i < matchers.length; ++i) {
                MatcherAssert.assertThat((String)("Request header[" + name + "]"), headerValues.get(i), (Matcher)matchers[i]);
            }
        };
    }

    public static RequestMatcher header(String name, String ... expectedValues) {
        return request -> {
            MockRestRequestMatchers.assertValueCount("header", name, (MultiValueMap<String, String>)request.getHeaders(), expectedValues.length);
            List headerValues = request.getHeaders().get((Object)name);
            org.springframework.util.Assert.state((headerValues != null ? 1 : 0) != 0, (String)"No header values");
            for (int i = 0; i < expectedValues.length; ++i) {
                AssertionErrors.assertEquals("Request header  [" + name + "]", expectedValues[i], headerValues.get(i));
            }
        };
    }

    public static ContentRequestMatchers content() {
        return new ContentRequestMatchers();
    }

    public static JsonPathRequestMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathRequestMatchers(expression, args);
    }

    public static <T> RequestMatcher jsonPath(String expression, Matcher<T> matcher) {
        return new JsonPathRequestMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathRequestMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, null, args);
    }

    public static XpathRequestMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, namespaces, args);
    }
}

