/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.reactive.function.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockServerRequest
implements ServerRequest {
    private final HttpMethod method;
    private final URI uri;
    private final RequestPath pathContainer;
    private final MockHeaders headers;
    private final MultiValueMap<String, HttpCookie> cookies;
    @Nullable
    private final Object body;
    private final Map<String, Object> attributes;
    private final MultiValueMap<String, String> queryParams;
    private final Map<String, String> pathVariables;
    @Nullable
    private final WebSession session;
    @Nullable
    private Principal principal;

    private MockServerRequest(HttpMethod method, URI uri, String contextPath, MockHeaders headers, MultiValueMap<String, HttpCookie> cookies, @Nullable Object body, Map<String, Object> attributes, MultiValueMap<String, String> queryParams, Map<String, String> pathVariables, @Nullable WebSession session, @Nullable Principal principal) {
        this.method = method;
        this.uri = uri;
        this.pathContainer = RequestPath.parse((URI)uri, (String)contextPath);
        this.headers = headers;
        this.cookies = cookies;
        this.body = body;
        this.attributes = attributes;
        this.queryParams = queryParams;
        this.pathVariables = pathVariables;
        this.session = session;
        this.principal = principal;
    }

    public HttpMethod method() {
        return this.method;
    }

    public String methodName() {
        return this.method.name();
    }

    public URI uri() {
        return this.uri;
    }

    public UriBuilder uriBuilder() {
        return UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServerRequestAdapter());
    }

    public PathContainer pathContainer() {
        return this.pathContainer;
    }

    public ServerRequest.Headers headers() {
        return this.headers;
    }

    public MultiValueMap<String, HttpCookie> cookies() {
        return this.cookies;
    }

    public <S> S body(BodyExtractor<S, ? super ServerHttpRequest> extractor) {
        Assert.state((this.body != null ? 1 : 0) != 0, (String)"No body");
        return (S)this.body;
    }

    public <S> S body(BodyExtractor<S, ? super ServerHttpRequest> extractor, Map<String, Object> hints) {
        Assert.state((this.body != null ? 1 : 0) != 0, (String)"No body");
        return (S)this.body;
    }

    public <S> Mono<S> bodyToMono(Class<? extends S> elementClass) {
        Assert.state((this.body != null ? 1 : 0) != 0, (String)"No body");
        return (Mono)this.body;
    }

    public <S> Mono<S> bodyToMono(ParameterizedTypeReference<S> typeReference) {
        Assert.state((this.body != null ? 1 : 0) != 0, (String)"No body");
        return (Mono)this.body;
    }

    public <S> Flux<S> bodyToFlux(Class<? extends S> elementClass) {
        Assert.state((this.body != null ? 1 : 0) != 0, (String)"No body");
        return (Flux)this.body;
    }

    public <S> Flux<S> bodyToFlux(ParameterizedTypeReference<S> typeReference) {
        Assert.state((this.body != null ? 1 : 0) != 0, (String)"No body");
        return (Flux)this.body;
    }

    public Map<String, Object> attributes() {
        return this.attributes;
    }

    public MultiValueMap<String, String> queryParams() {
        return CollectionUtils.unmodifiableMultiValueMap(this.queryParams);
    }

    public Map<String, String> pathVariables() {
        return Collections.unmodifiableMap(this.pathVariables);
    }

    public Mono<WebSession> session() {
        return Mono.justOrEmpty((Object)this.session);
    }

    public Mono<? extends Principal> principal() {
        return Mono.justOrEmpty((Object)this.principal);
    }

    public Mono<MultiValueMap<String, String>> formData() {
        Assert.state((this.body != null ? 1 : 0) != 0, (String)"No body");
        return (Mono)this.body;
    }

    public Mono<MultiValueMap<String, Part>> multipartData() {
        Assert.state((this.body != null ? 1 : 0) != 0, (String)"No body");
        return (Mono)this.body;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private final class ServerRequestAdapter
    implements HttpRequest {
        private ServerRequestAdapter() {
        }

        public String getMethodValue() {
            return MockServerRequest.this.methodName();
        }

        public URI getURI() {
            return MockServerRequest.this.uri;
        }

        public HttpHeaders getHeaders() {
            return MockServerRequest.this.headers.headers;
        }
    }

    private static class MockHeaders
    implements ServerRequest.Headers {
        private final HttpHeaders headers;

        public MockHeaders(HttpHeaders headers) {
            this.headers = headers;
        }

        private HttpHeaders delegate() {
            return this.headers;
        }

        public void header(String key, String value) {
            this.headers.add(key, value);
        }

        public List<MediaType> accept() {
            return this.delegate().getAccept();
        }

        public List<Charset> acceptCharset() {
            return this.delegate().getAcceptCharset();
        }

        public List<Locale.LanguageRange> acceptLanguage() {
            return this.delegate().getAcceptLanguage();
        }

        public OptionalLong contentLength() {
            return this.toOptionalLong(this.delegate().getContentLength());
        }

        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.delegate().getContentType());
        }

        public InetSocketAddress host() {
            return this.delegate().getHost();
        }

        public List<HttpRange> range() {
            return this.delegate().getRange();
        }

        public List<String> header(String headerName) {
            List<String> headerValues = this.delegate().get((Object)headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        public HttpHeaders asHttpHeaders() {
            return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.delegate());
        }

        private OptionalLong toOptionalLong(long value) {
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }
    }

    private static class BuilderImpl
    implements Builder {
        private HttpMethod method = HttpMethod.GET;
        private URI uri = URI.create("http://localhost");
        private String contextPath = "";
        private MockHeaders headers = new MockHeaders(new HttpHeaders());
        private MultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();
        @Nullable
        private Object body;
        private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        private MultiValueMap<String, String> queryParams = new LinkedMultiValueMap();
        private Map<String, String> pathVariables = new LinkedHashMap<String, String>();
        @Nullable
        private WebSession session;
        @Nullable
        private Principal principal;

        private BuilderImpl() {
        }

        @Override
        public Builder method(HttpMethod method) {
            Assert.notNull((Object)method, (String)"'method' must not be null");
            this.method = method;
            return this;
        }

        @Override
        public Builder uri(URI uri) {
            Assert.notNull((Object)uri, (String)"'uri' must not be null");
            this.uri = uri;
            return this;
        }

        @Override
        public Builder contextPath(String contextPath) {
            Assert.notNull((Object)contextPath, (String)"'contextPath' must not be null");
            this.contextPath = contextPath;
            return this;
        }

        @Override
        public Builder cookie(HttpCookie ... cookies) {
            Arrays.stream(cookies).forEach(cookie -> this.cookies.add((Object)cookie.getName(), cookie));
            return this;
        }

        @Override
        public Builder cookies(MultiValueMap<String, HttpCookie> cookies) {
            Assert.notNull(cookies, (String)"'cookies' must not be null");
            this.cookies = cookies;
            return this;
        }

        @Override
        public Builder header(String key, String value) {
            Assert.notNull((Object)key, (String)"'key' must not be null");
            Assert.notNull((Object)value, (String)"'value' must not be null");
            this.headers.header(key, value);
            return this;
        }

        @Override
        public Builder headers(HttpHeaders headers) {
            Assert.notNull((Object)headers, (String)"'headers' must not be null");
            this.headers = new MockHeaders(headers);
            return this;
        }

        @Override
        public Builder attribute(String name, Object value) {
            Assert.notNull((Object)name, (String)"'name' must not be null");
            Assert.notNull((Object)value, (String)"'value' must not be null");
            this.attributes.put(name, value);
            return this;
        }

        @Override
        public Builder attributes(Map<String, Object> attributes) {
            Assert.notNull(attributes, (String)"'attributes' must not be null");
            this.attributes = attributes;
            return this;
        }

        @Override
        public Builder queryParam(String key, String value) {
            Assert.notNull((Object)key, (String)"'key' must not be null");
            Assert.notNull((Object)value, (String)"'value' must not be null");
            this.queryParams.add((Object)key, (Object)value);
            return this;
        }

        @Override
        public Builder queryParams(MultiValueMap<String, String> queryParams) {
            Assert.notNull(queryParams, (String)"'queryParams' must not be null");
            this.queryParams = queryParams;
            return this;
        }

        @Override
        public Builder pathVariable(String key, String value) {
            Assert.notNull((Object)key, (String)"'key' must not be null");
            Assert.notNull((Object)value, (String)"'value' must not be null");
            this.pathVariables.put(key, value);
            return this;
        }

        @Override
        public Builder pathVariables(Map<String, String> pathVariables) {
            Assert.notNull(pathVariables, (String)"'pathVariables' must not be null");
            this.pathVariables = pathVariables;
            return this;
        }

        @Override
        public Builder session(WebSession session) {
            Assert.notNull((Object)session, (String)"'session' must not be null");
            this.session = session;
            return this;
        }

        @Override
        public Builder session(Principal principal) {
            Assert.notNull((Object)principal, (String)"'principal' must not be null");
            this.principal = principal;
            return this;
        }

        @Override
        public MockServerRequest body(Object body) {
            this.body = body;
            return new MockServerRequest(this.method, this.uri, this.contextPath, this.headers, this.cookies, this.body, this.attributes, this.queryParams, this.pathVariables, this.session, this.principal);
        }

        @Override
        public MockServerRequest build() {
            return new MockServerRequest(this.method, this.uri, this.contextPath, this.headers, this.cookies, null, this.attributes, this.queryParams, this.pathVariables, this.session, this.principal);
        }
    }

    public static interface Builder {
        public Builder method(HttpMethod var1);

        public Builder uri(URI var1);

        public Builder contextPath(String var1);

        public Builder header(String var1, String var2);

        public Builder headers(HttpHeaders var1);

        public Builder cookie(HttpCookie ... var1);

        public Builder cookies(MultiValueMap<String, HttpCookie> var1);

        public Builder attribute(String var1, Object var2);

        public Builder attributes(Map<String, Object> var1);

        public Builder queryParam(String var1, String var2);

        public Builder queryParams(MultiValueMap<String, String> var1);

        public Builder pathVariable(String var1, String var2);

        public Builder pathVariables(Map<String, String> var1);

        public Builder session(WebSession var1);

        public Builder session(Principal var1);

        public MockServerRequest body(Object var1);

        public MockServerRequest build();
    }
}

