/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertySourceDescriptor;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ClassUtils;

class MergedContextConfigurationRuntimeHints {
    private static final String SLASH = "/";
    private static final String WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME = "org.springframework.test.context.web.WebMergedContextConfiguration";
    private static final String GET_RESOURCE_BASE_PATH_METHOD_NAME = "getResourceBasePath";
    private static final Class<?> WEB_MERGED_CONTEXT_CONFIGURATION_CLASS = MergedContextConfigurationRuntimeHints.loadWebMergedContextConfigurationClass();
    private static final Method getResourceBasePathMethod = MergedContextConfigurationRuntimeHints.loadGetResourceBasePathMethod();
    private final Log logger = LogFactory.getLog(this.getClass());

    MergedContextConfigurationRuntimeHints() {
    }

    public void registerHints(RuntimeHints runtimeHints, MergedContextConfiguration mergedConfig, ClassLoader classLoader) {
        ContextLoader contextLoader = mergedConfig.getContextLoader();
        if (contextLoader != null) {
            this.registerDeclaredConstructors(contextLoader.getClass(), runtimeHints);
        }
        mergedConfig.getContextInitializerClasses().forEach(clazz -> this.registerDeclaredConstructors((Class<?>)clazz, runtimeHints));
        this.registerClasspathResources("@ContextConfiguration", mergedConfig.getLocations(), runtimeHints, classLoader);
        for (PropertySourceDescriptor descriptor : mergedConfig.getPropertySourceDescriptors()) {
            this.registerClasspathResources("@TestPropertySource", descriptor.locations(), runtimeHints, classLoader);
            Class factoryClass = descriptor.propertySourceFactory();
            if (factoryClass == null) continue;
            this.registerDeclaredConstructors(factoryClass, runtimeHints);
        }
        if (WEB_MERGED_CONTEXT_CONFIGURATION_CLASS.isInstance(mergedConfig)) {
            String resourceBasePath;
            try {
                resourceBasePath = (String)getResourceBasePathMethod.invoke((Object)mergedConfig, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to invoke WebMergedContextConfiguration#getResourceBasePath()", ex);
            }
            this.registerClasspathResourceDirectoryStructure(resourceBasePath, runtimeHints);
        }
    }

    private void registerDeclaredConstructors(Class<?> type, RuntimeHints runtimeHints) {
        runtimeHints.reflection().registerType(type, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
    }

    private void registerClasspathResources(String annotation, String[] locations, RuntimeHints runtimeHints, ClassLoader classLoader) {
        this.registerClasspathResources(annotation, Arrays.asList(locations), runtimeHints, classLoader);
    }

    private void registerClasspathResources(String annotation, List<String> locations, RuntimeHints runtimeHints, ClassLoader classLoader) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(classLoader);
        ResourceHints resourceHints = runtimeHints.resources();
        for (String location : locations) {
            ClassPathResource classPathResource;
            if (location.startsWith("classpath*:") || location.startsWith("classpath:") && (location.contains("*") || location.contains("?"))) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)"Runtime hint registration is not supported for the 'classpath*:' prefix or wildcards in %s locations. Please manually register a resource hint for each location represented by '%s'.".formatted(annotation, location));
                continue;
            }
            Resource resource = resourceLoader.getResource(location);
            if (!(resource instanceof ClassPathResource) || !(classPathResource = (ClassPathResource)resource).exists()) continue;
            resourceHints.registerPattern(classPathResource.getPath());
        }
    }

    private void registerClasspathResourceDirectoryStructure(String directory, RuntimeHints runtimeHints) {
        if (directory.startsWith("classpath:")) {
            Object pattern = directory.substring("classpath:".length());
            if (((String)pattern).startsWith(SLASH)) {
                pattern = ((String)pattern).substring(1);
            }
            if (!((String)pattern).endsWith(SLASH)) {
                pattern = (String)pattern + SLASH;
            }
            pattern = (String)pattern + "**";
            runtimeHints.resources().registerPattern((String)pattern);
        }
    }

    private static Class<?> loadWebMergedContextConfigurationClass() {
        try {
            return ClassUtils.forName((String)WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME, (ClassLoader)MergedContextConfigurationRuntimeHints.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError ex) {
            throw new IllegalStateException("Failed to load class org.springframework.test.context.web.WebMergedContextConfiguration", ex);
        }
    }

    private static Method loadGetResourceBasePathMethod() {
        try {
            return WEB_MERGED_CONTEXT_CONFIGURATION_CLASS.getMethod(GET_RESOURCE_BASE_PATH_METHOD_NAME, new Class[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to load method WebMergedContextConfiguration#getResourceBasePath()", ex);
        }
    }
}

