/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.util.WebUtils;

public class ServletRequestAttributes
extends AbstractRequestAttributes {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = (class$org$springframework$web$context$request$ServletRequestAttributes == null ? (class$org$springframework$web$context$request$ServletRequestAttributes = ServletRequestAttributes.class$("org.springframework.web.context.request.ServletRequestAttributes")) : class$org$springframework$web$context$request$ServletRequestAttributes).getName() + ".DESTRUCTION_CALLBACK.";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$context$request$ServletRequestAttributes == null ? (class$org$springframework$web$context$request$ServletRequestAttributes = ServletRequestAttributes.class$("org.springframework.web.context.request.ServletRequestAttributes")) : class$org$springframework$web$context$request$ServletRequestAttributes));
    private static final boolean bindingListenerAvailable = ClassUtils.isPresent((String)"javax.servlet.http.HttpSessionBindingListener", (ClassLoader)(class$org$springframework$web$context$request$ServletRequestAttributes == null ? (class$org$springframework$web$context$request$ServletRequestAttributes = ServletRequestAttributes.class$("org.springframework.web.context.request.ServletRequestAttributes")) : class$org$springframework$web$context$request$ServletRequestAttributes).getClassLoader());
    private final HttpServletRequest request;
    private HttpSession session;
    private final Map sessionAttributesToUpdate = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$context$request$ServletRequestAttributes;

    public ServletRequestAttributes(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.request = request;
        this.session = request.getSession(false);
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    protected final HttpSession getSession(boolean allowCreate) {
        try {
            this.session = this.request.getSession(allowCreate);
            return this.session;
        }
        catch (IllegalStateException ex) {
            if (this.session == null) {
                throw ex;
            }
            if (allowCreate) {
                boolean canAskForExistingSession = false;
                try {
                    this.session = this.request.getSession(false);
                    canAskForExistingSession = true;
                }
                catch (IllegalStateException ex2) {
                    // empty catch block
                }
                if (canAskForExistingSession) {
                    throw ex;
                }
            }
            return this.session;
        }
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            return this.request.getAttribute(name);
        }
        HttpSession session = this.getSession(false);
        if (session != null) {
            Object value = session.getAttribute(name);
            if (value != null) {
                this.sessionAttributesToUpdate.put(name, value);
            }
            return value;
        }
        return null;
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            this.request.setAttribute(name, value);
        } else {
            HttpSession session = this.getSession(true);
            session.setAttribute(name, value);
            this.sessionAttributesToUpdate.remove(name);
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 0) {
            this.request.removeAttribute(name);
            this.removeRequestDestructionCallback(name);
        } else {
            HttpSession session = this.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
                this.sessionAttributesToUpdate.remove(name);
                session.removeAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name);
            }
        }
    }

    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        if (scope == 0) {
            this.registerRequestDestructionCallback(name, callback);
        } else {
            this.registerSessionDestructionCallback(name, callback);
        }
    }

    public String getSessionId() {
        return this.getSession(true).getId();
    }

    public Object getSessionMutex() {
        return WebUtils.getSessionMutex(this.getSession(true));
    }

    protected void updateAccessedSessionAttributes() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            Iterator it = this.sessionAttributesToUpdate.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Object newValue = entry.getValue();
                Object oldValue = session.getAttribute(name);
                if (oldValue != newValue) continue;
                session.setAttribute(name, newValue);
            }
        }
        this.sessionAttributesToUpdate.clear();
    }

    private void registerSessionDestructionCallback(String name, Runnable callback) {
        if (bindingListenerAvailable) {
            HttpSession session = this.getSession(true);
            session.setAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name, (Object)new DestructionCallbackBindingListener(callback));
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Could not register destruction callback [" + callback + "] for attribute '" + name + "' in session scope because Servlet 2.3 API is not available"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DestructionCallbackBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private final Runnable destructionCallback;

        public DestructionCallbackBindingListener(Runnable destructionCallback) {
            this.destructionCallback = destructionCallback;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            this.destructionCallback.run();
        }
    }
}

